/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.ConnectionCompletionVo;
import org.tio.client.ReconnConf;
import org.tio.client.TioClient;
import org.tio.client.TioClientConfig;
import org.tio.client.intf.TioClientListener;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.core.ReadCompletionHandler;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.ssl.SslFacadeContext;
import org.tio.core.ssl.SslUtils;
import org.tio.core.stat.IpStat;
import org.tio.utils.SystemTimer;

public class ConnectionCompletionHandler
implements CompletionHandler<Void, ConnectionCompletionVo> {
    private static Logger log = LoggerFactory.getLogger(ConnectionCompletionHandler.class);

    @Override
    public void completed(Void result, ConnectionCompletionVo attachment) {
        this.handler(result, attachment, null);
    }

    @Override
    public void failed(Throwable throwable, ConnectionCompletionVo attachment) {
        this.handler(null, attachment, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void handler(Void result, ConnectionCompletionVo attachment, Throwable throwable) {
        block50: {
            boolean isConnected;
            boolean isReconnect;
            TioClientListener tioClientListener;
            ClientChannelContext channelContext;
            block49: {
                channelContext = attachment.getChannelContext();
                AsynchronousSocketChannel asynchronousSocketChannel = attachment.getAsynchronousSocketChannel();
                TioClient tioClient = attachment.getTioClient();
                TioClientConfig tioClientConfig = tioClient.getTioClientConfig();
                Node serverNode = attachment.getServerNode();
                String bindIp = attachment.getBindIp();
                Integer bindPort = attachment.getBindPort();
                tioClientListener = tioClientConfig.getTioClientListener();
                isReconnect = attachment.isReconnect();
                isConnected = false;
                if (throwable == null) {
                    if (isReconnect) {
                        channelContext.setAsynchronousSocketChannel(asynchronousSocketChannel);
                        channelContext.handlerRunnable.setCanceled(false);
                        channelContext.sendRunnable.setCanceled(false);
                        tioClientConfig.closeds.remove((Object)channelContext);
                    } else {
                        channelContext = new ClientChannelContext((TioConfig)tioClientConfig, asynchronousSocketChannel);
                        channelContext.setServerNode(serverNode);
                    }
                    channelContext.setBindIp(bindIp);
                    channelContext.setBindPort(bindPort);
                    channelContext.getReconnCount().set(0);
                    channelContext.setClosed(false);
                    isConnected = true;
                    attachment.setChannelContext(channelContext);
                    tioClientConfig.connecteds.add((Object)channelContext);
                    ReadCompletionHandler readCompletionHandler = channelContext.getReadCompletionHandler();
                    ByteBuffer readByteBuffer = readCompletionHandler.getReadByteBuffer();
                    readByteBuffer.position(0);
                    readByteBuffer.limit(readByteBuffer.capacity());
                    asynchronousSocketChannel.read(readByteBuffer, readByteBuffer, readCompletionHandler);
                    log.info("connected to {}", (Object)serverNode);
                    if (isConnected && !isReconnect) {
                        channelContext.stat.setTimeFirstConnected(SystemTimer.currTime);
                    }
                } else {
                    boolean f;
                    ReconnConf reconnConf;
                    log.error(throwable.toString(), throwable);
                    if (channelContext == null && (reconnConf = tioClientConfig.getReconnConf()) != null) {
                        channelContext = new ClientChannelContext((TioConfig)tioClientConfig, asynchronousSocketChannel);
                        channelContext.setServerNode(serverNode);
                    }
                    if (!isReconnect && channelContext != null) {
                        attachment.setChannelContext(channelContext);
                    }
                    if (!(f = ReconnConf.put(channelContext))) {
                        Tio.close(channelContext, null, "\u4e0d\u9700\u8981\u91cd\u8fde\uff0c\u5173\u95ed\u8be5\u8fde\u63a5", true, false, ChannelContext.CloseCode.CLIENT_CONNECTION_FAIL);
                    }
                }
                if (attachment.getCountDownLatch() == null) break block49;
                attachment.getCountDownLatch().countDown();
            }
            try {
                if (channelContext == null) break block50;
                channelContext.setReconnect(isReconnect);
                if (SslUtils.isSsl(channelContext.tioConfig)) {
                    if (isConnected) {
                        SslFacadeContext sslFacadeContext = new SslFacadeContext(channelContext);
                        sslFacadeContext.beginHandshake();
                    } else if (tioClientListener != null) {
                        if (isConnected) {
                            channelContext.stat.heartbeatTimeoutCount.set(0);
                            channelContext.setCloseCode(ChannelContext.CloseCode.INIT_STATUS);
                        }
                        tioClientListener.onAfterConnected(channelContext, isConnected, isReconnect);
                    }
                } else if (tioClientListener != null) {
                    tioClientListener.onAfterConnected(channelContext, isConnected, isReconnect);
                }
                TioConfig tioConfig = channelContext.tioConfig;
                if (!tioConfig.isIpStatEnable()) break block50;
                try {
                    for (Long v : tioConfig.ipStats.durationList) {
                        IpStat ipStat = tioConfig.ipStats.get(v, channelContext);
                        ipStat.getRequestCount().incrementAndGet();
                        tioConfig.getIpStatListener().onAfterConnected(channelContext, isConnected, isReconnect, ipStat);
                    }
                    break block50;
                }
                catch (Exception e2) {
                    log.error(e2.toString(), (Throwable)e2);
                }
            }
            catch (Throwable e1) {
                log.error(e1.toString(), e1);
            }
            break block50;
            catch (Throwable e) {
                block51: {
                    log.error(e.toString(), e);
                    if (attachment.getCountDownLatch() == null) break block51;
                    attachment.getCountDownLatch().countDown();
                }
                try {
                    if (channelContext == null) break block50;
                    channelContext.setReconnect(isReconnect);
                    if (SslUtils.isSsl(channelContext.tioConfig)) {
                        if (isConnected) {
                            SslFacadeContext sslFacadeContext = new SslFacadeContext(channelContext);
                            sslFacadeContext.beginHandshake();
                        } else if (tioClientListener != null) {
                            if (isConnected) {
                                channelContext.stat.heartbeatTimeoutCount.set(0);
                                channelContext.setCloseCode(ChannelContext.CloseCode.INIT_STATUS);
                            }
                            tioClientListener.onAfterConnected(channelContext, isConnected, isReconnect);
                        }
                    } else if (tioClientListener != null) {
                        tioClientListener.onAfterConnected(channelContext, isConnected, isReconnect);
                    }
                    TioConfig tioConfig = channelContext.tioConfig;
                    if (!tioConfig.isIpStatEnable()) break block50;
                    try {
                        for (Long v : tioConfig.ipStats.durationList) {
                            IpStat ipStat = tioConfig.ipStats.get(v, channelContext);
                            ipStat.getRequestCount().incrementAndGet();
                            tioConfig.getIpStatListener().onAfterConnected(channelContext, isConnected, isReconnect, ipStat);
                        }
                    }
                    catch (Exception e2) {
                        log.error(e2.toString(), (Throwable)e2);
                    }
                }
                catch (Throwable e1) {
                    log.error(e1.toString(), e1);
                }
                catch (Throwable throwable2) {
                    block52: {
                        if (attachment.getCountDownLatch() != null) {
                            attachment.getCountDownLatch().countDown();
                        }
                        try {
                            if (channelContext == null) break block52;
                            channelContext.setReconnect(isReconnect);
                            if (SslUtils.isSsl(channelContext.tioConfig)) {
                                if (isConnected) {
                                    SslFacadeContext sslFacadeContext = new SslFacadeContext(channelContext);
                                    sslFacadeContext.beginHandshake();
                                } else if (tioClientListener != null) {
                                    if (isConnected) {
                                        channelContext.stat.heartbeatTimeoutCount.set(0);
                                        channelContext.setCloseCode(ChannelContext.CloseCode.INIT_STATUS);
                                    }
                                    tioClientListener.onAfterConnected(channelContext, isConnected, isReconnect);
                                }
                            } else if (tioClientListener != null) {
                                tioClientListener.onAfterConnected(channelContext, isConnected, isReconnect);
                            }
                            TioConfig tioConfig = channelContext.tioConfig;
                            if (!tioConfig.isIpStatEnable()) break block52;
                            try {
                                for (Long v : tioConfig.ipStats.durationList) {
                                    IpStat ipStat = tioConfig.ipStats.get(v, channelContext);
                                    ipStat.getRequestCount().incrementAndGet();
                                    tioConfig.getIpStatListener().onAfterConnected(channelContext, isConnected, isReconnect, ipStat);
                                }
                            }
                            catch (Exception e3) {
                                log.error(e3.toString(), (Throwable)e3);
                            }
                        }
                        catch (Throwable e1) {
                            log.error(e1.toString(), e1);
                        }
                    }
                    throw throwable2;
                }
            }
        }
    }
}

