/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.io.Serializable;
import java.util.Collection;
import java.util.function.Consumer;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.server.TioServerConfig;
import org.tio.utils.SystemTimer;
import org.tio.utils.cache.caffeine.CaffeineCache;
import org.tio.utils.time.Time;

public class IpBlacklist {
    private String id;
    private static final String CACHE_NAME_PREFIX = "TIO_IP_BLACK_LIST";
    private static final Long TIME_TO_LIVE_SECONDS = Time.DAY_1 * 120L;
    private static final Long TIME_TO_IDLE_SECONDS = null;
    private String cacheName = null;
    private CaffeineCache cache = null;
    private TioServerConfig tioServerConfig;
    public static final IpBlacklist GLOBAL = new IpBlacklist();

    private IpBlacklist() {
        this.id = "__global__";
        this.cacheName = CACHE_NAME_PREFIX + this.id;
        this.cache = CaffeineCache.register((String)this.cacheName, (Long)TIME_TO_LIVE_SECONDS, (Long)TIME_TO_IDLE_SECONDS, null);
    }

    public IpBlacklist(String id, TioServerConfig tioServerConfig) {
        this.id = id;
        this.tioServerConfig = tioServerConfig;
        this.cacheName = CACHE_NAME_PREFIX + this.id;
        this.cache = CaffeineCache.register((String)this.cacheName, (Long)TIME_TO_LIVE_SECONDS, (Long)TIME_TO_IDLE_SECONDS, null);
    }

    public boolean add(final String ip) {
        this.cache.put(ip, (Serializable)Long.valueOf(SystemTimer.currTime));
        if (this.tioServerConfig != null) {
            Tio.remove(this.tioServerConfig, ip, "ip[" + ip + "]\u88ab\u52a0\u5165\u4e86\u9ed1\u540d\u5355, " + this.tioServerConfig.getName());
        } else {
            TioConfig.ALL_SERVER_GROUPCONTEXTS.stream().forEach(new Consumer<TioServerConfig>(){

                @Override
                public void accept(TioServerConfig tioConfig) {
                    Tio.remove(tioConfig, ip, "ip[" + ip + "]\u88ab\u52a0\u5165\u4e86\u9ed1\u540d\u5355, " + tioConfig.getName());
                }
            });
        }
        return true;
    }

    public void clear() {
        this.cache.clear();
    }

    public Collection<String> getAll() {
        return this.cache.keys();
    }

    public boolean isInBlacklist(String ip) {
        return this.cache.get(ip) != null;
    }

    public void remove(String ip) {
        this.cache.remove(ip);
    }
}

