/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import com.github.benmanes.caffeine.cache.RemovalListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.core.cache.IpStatRemovalListener;
import org.tio.core.stat.IpStat;
import org.tio.utils.cache.caffeine.CaffeineCache;
import org.tio.utils.hutool.CollUtil;

public class IpStats {
    private static Logger log = LoggerFactory.getLogger(IpStats.class);
    private static final String CACHE_NAME = "TIO_IP_STAT";
    private String tioConfigId;
    private TioConfig tioConfig;
    public final Map<Long, CaffeineCache> cacheMap = new HashMap<Long, CaffeineCache>();
    public List<Long> durationList = null;

    public IpStats(TioConfig tioConfig, Long[] durations) {
        this.tioConfig = tioConfig;
        this.tioConfigId = tioConfig.getId();
        if (durations != null) {
            this.addDurations(durations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDuration(Long duration) {
        IpStats ipStats = this;
        synchronized (ipStats) {
            if (this.durationList == null) {
                this.durationList = new ArrayList<Long>();
            }
            CaffeineCache caffeineCache = CaffeineCache.register((String)this.getCacheName(duration), (Long)duration, null, (RemovalListener)new IpStatRemovalListener(this.tioConfig, this.tioConfig.getIpStatListener()));
            this.cacheMap.put(duration, caffeineCache);
            this.durationList.add(duration);
        }
    }

    public void addDurations(Long[] durations) {
        if (durations != null) {
            for (Long duration : durations) {
                this.addDuration(duration);
            }
        }
    }

    public void removeDuration(Long duration) {
        this.clear(duration);
        this.cacheMap.remove(duration);
        if (CollUtil.isNotEmpty(this.durationList)) {
            this.durationList.remove(duration);
        }
    }

    public String getCacheName(Long duration) {
        String cacheName = "TIO_IP_STAT_" + this.tioConfigId + "_";
        return cacheName + duration;
    }

    public void clear(Long duration) {
        CaffeineCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return;
        }
        caffeineCache.clear();
    }

    public IpStat get(Long duration, ChannelContext channelContext) {
        return this.get(duration, channelContext, true);
    }

    public IpStat get(Long duration, ChannelContext channelContext, boolean forceCreate) {
        return this._get(duration, channelContext, forceCreate, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpStat _get(Long duration, ChannelContext channelContext, boolean forceCreate, boolean useProxyClient) {
        if (channelContext == null) {
            return null;
        }
        CaffeineCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        String ip = null;
        ip = useProxyClient && channelContext.getProxyClientNode() != null ? channelContext.getProxyClientNode().getIp() : channelContext.getClientNode().getIp();
        IpStat ipStat = (IpStat)caffeineCache.get(ip);
        if (ipStat == null && forceCreate) {
            IpStats ipStats = this;
            synchronized (ipStats) {
                ipStat = (IpStat)caffeineCache.get(ip);
                if (ipStat == null) {
                    ipStat = new IpStat(ip, duration);
                    caffeineCache.put(ip, (Serializable)ipStat);
                }
            }
        }
        return ipStat;
    }

    public ConcurrentMap<String, Serializable> map(Long duration) {
        CaffeineCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        ConcurrentMap map = caffeineCache.asMap();
        return map;
    }

    public Long size(Long duration) {
        CaffeineCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        return caffeineCache.size();
    }

    public Collection<Serializable> values(Long duration) {
        CaffeineCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        Collection<Serializable> set = caffeineCache.asMap().values();
        return set;
    }
}

