/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Node;
import org.tio.server.AcceptCompletionHandler;
import org.tio.server.TioServerConfig;
import org.tio.utils.hutool.DateUtil;
import org.tio.utils.hutool.StrUtil;

public class TioServer {
    private static Logger log = LoggerFactory.getLogger(TioServer.class);
    private TioServerConfig tioServerConfig;
    private AsynchronousServerSocketChannel serverSocketChannel;
    private AsynchronousChannelGroup channelGroup = null;
    private Node serverNode;
    private boolean isWaitingStop = false;
    private boolean checkLastVersion = true;

    public TioServer(TioServerConfig tioServerConfig) {
        this.tioServerConfig = tioServerConfig;
    }

    public TioServerConfig getTioServerConfig() {
        return this.tioServerConfig;
    }

    public Node getServerNode() {
        return this.serverNode;
    }

    public AsynchronousServerSocketChannel getServerSocketChannel() {
        return this.serverSocketChannel;
    }

    public boolean isWaitingStop() {
        return this.isWaitingStop;
    }

    public void setTioServerConfig(TioServerConfig tioServerConfig) {
        this.tioServerConfig = tioServerConfig;
    }

    public void setWaitingStop(boolean isWaitingStop) {
        this.isWaitingStop = isWaitingStop;
    }

    public void start(String serverIp, int serverPort) throws IOException {
        long start = System.currentTimeMillis();
        this.serverNode = new Node(serverIp, serverPort);
        this.channelGroup = AsynchronousChannelGroup.withThreadPool(this.tioServerConfig.groupExecutor);
        this.serverSocketChannel = AsynchronousServerSocketChannel.open(this.channelGroup);
        this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)65536);
        InetSocketAddress listenAddress = null;
        listenAddress = StrUtil.isBlank((CharSequence)serverIp) ? new InetSocketAddress(serverPort) : new InetSocketAddress(serverIp, serverPort);
        this.serverSocketChannel.bind(listenAddress, 0);
        AcceptCompletionHandler acceptCompletionHandler = this.tioServerConfig.getAcceptCompletionHandler();
        this.serverSocketChannel.accept(this, acceptCompletionHandler);
        this.tioServerConfig.startTime = System.currentTimeMillis();
        String baseStr = "|----------------------------------------------------------------------------------------|";
        int baseLen = baseStr.length();
        StackTraceElement[] ses = Thread.currentThread().getStackTrace();
        StackTraceElement se = ses[ses.length - 1];
        int xxLen = 18;
        int aaLen = baseLen - 3;
        ArrayList<String> infoList = new ArrayList<String>();
        infoList.add(StrUtil.fillAfter((String)"t-io site", (char)' ', (int)xxLen) + "| " + "https://www.tiocloud.com");
        infoList.add(StrUtil.fillAfter((String)"t-io on gitee", (char)' ', (int)xxLen) + "| " + "https://gitee.com/tywo45/t-io");
        infoList.add(StrUtil.fillAfter((String)"t-io on github", (char)' ', (int)xxLen) + "| " + "https://github.com/tywo45/t-io");
        infoList.add(StrUtil.fillAfter((String)"t-io version", (char)' ', (int)xxLen) + "| " + "3.8.3.v20220902-RELEASE");
        infoList.add(StrUtil.fillAfter((String)"-", (char)'-', (int)aaLen));
        infoList.add(StrUtil.fillAfter((String)"TioConfig name", (char)' ', (int)xxLen) + "| " + this.tioServerConfig.getName());
        infoList.add(StrUtil.fillAfter((String)"Started at", (char)' ', (int)xxLen) + "| " + DateUtil.formatDateTime((Date)new Date()));
        infoList.add(StrUtil.fillAfter((String)"Listen on", (char)' ', (int)xxLen) + "| " + this.serverNode);
        infoList.add(StrUtil.fillAfter((String)"Main Class", (char)' ', (int)xxLen) + "| " + se.getClassName());
        try {
            RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
            String runtimeName = runtimeMxBean.getName();
            String pid = runtimeName.split("@")[0];
            long startTime = runtimeMxBean.getStartTime();
            long startCost = System.currentTimeMillis() - startTime;
            infoList.add(StrUtil.fillAfter((String)"Jvm start time", (char)' ', (int)xxLen) + "| " + startCost + "ms");
            infoList.add(StrUtil.fillAfter((String)"Tio start time", (char)' ', (int)xxLen) + "| " + (System.currentTimeMillis() - start) + "ms");
            infoList.add(StrUtil.fillAfter((String)"Pid", (char)' ', (int)xxLen) + "| " + pid);
        }
        catch (Exception runtimeMxBean) {
            // empty catch block
        }
        String printStr = "\r\n" + baseStr + "\r\n";
        for (String string : infoList) {
            printStr = printStr + "| " + StrUtil.fillAfter((String)string, (char)' ', (int)aaLen) + "|\r\n";
        }
        printStr = printStr + baseStr + "\r\n";
        if (log.isInfoEnabled()) {
            log.info(printStr);
        } else {
            System.out.println(printStr);
        }
    }

    public boolean stop() {
        this.isWaitingStop = true;
        boolean ret = true;
        try {
            this.channelGroup.shutdownNow();
        }
        catch (Exception e) {
            log.error("channelGroup.shutdownNow()\u65f6\u62a5\u9519", (Throwable)e);
        }
        try {
            this.serverSocketChannel.close();
        }
        catch (Exception e1) {
            log.error("serverSocketChannel.close()\u65f6\u62a5\u9519", (Throwable)e1);
        }
        try {
            this.tioServerConfig.groupExecutor.shutdown();
        }
        catch (Exception e1) {
            log.error(e1.toString(), (Throwable)e1);
        }
        try {
            this.tioServerConfig.tioExecutor.shutdown();
        }
        catch (Exception e1) {
            log.error(e1.toString(), (Throwable)e1);
        }
        this.tioServerConfig.setStopped(true);
        try {
            ret = ret && this.tioServerConfig.groupExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
            ret = ret && this.tioServerConfig.tioExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        log.info(this.serverNode + " stopped");
        return ret;
    }

    public boolean isCheckLastVersion() {
        return this.checkLastVersion;
    }

    public void setCheckLastVersion(boolean checkLastVersion) {
        log.debug("community edition is no longer supported");
    }
}

