/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client;

import java.util.HashSet;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientGroupStat;
import org.tio.client.ConnectionCompletionHandler;
import org.tio.client.DefaultTioClientListener;
import org.tio.client.ReconnConf;
import org.tio.client.intf.TioClientHandler;
import org.tio.client.intf.TioClientListener;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.core.intf.TioHandler;
import org.tio.core.intf.TioListener;
import org.tio.core.ssl.SslConfig;
import org.tio.utils.lock.SetWithLock;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

public class TioClientConfig
extends TioConfig {
    static Logger log = LoggerFactory.getLogger(TioClientConfig.class);
    private TioClientHandler tioClientHandler = null;
    private TioClientListener tioClientListener = null;
    protected ReconnConf reconnConf;
    private ConnectionCompletionHandler connectionCompletionHandler = new ConnectionCompletionHandler();
    public final SetWithLock<ChannelContext> connecteds = new SetWithLock(new HashSet());
    public final SetWithLock<ChannelContext> closeds = new SetWithLock(new HashSet());

    public TioClientConfig(TioClientHandler tioHandler, TioClientListener tioListener) {
        this(tioHandler, tioListener, null);
    }

    public TioClientConfig(TioClientHandler tioHandler, TioClientListener tioListener, ReconnConf reconnConf) {
        this(tioHandler, tioListener, reconnConf, null, null);
    }

    public TioClientConfig(TioClientHandler tioHandler, TioClientListener tioListener, ReconnConf reconnConf, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        super(tioExecutor, groupExecutor);
        this.groupStat = new ClientGroupStat();
        this.setTioClientHandler(tioHandler);
        this.setTioClientListener(tioListener);
        this.reconnConf = reconnConf;
    }

    public void useSsl() throws Exception {
        SslConfig sslConfig = SslConfig.forClient();
        this.setSslConfig(sslConfig);
    }

    @Override
    public TioHandler getTioHandler() {
        return this.getTioClientHandler();
    }

    @Override
    public TioListener getTioListener() {
        return this.getTioClientListener();
    }

    public TioClientHandler getTioClientHandler() {
        return this.tioClientHandler;
    }

    public TioClientListener getTioClientListener() {
        return this.tioClientListener;
    }

    public ConnectionCompletionHandler getConnectionCompletionHandler() {
        return this.connectionCompletionHandler;
    }

    public void setTioClientHandler(TioClientHandler tioClientHandler) {
        this.tioClientHandler = tioClientHandler;
    }

    public void setTioClientListener(TioClientListener tioClientListener) {
        this.tioClientListener = tioClientListener;
        if (this.tioClientListener == null) {
            this.tioClientListener = new DefaultTioClientListener();
        }
    }

    public void setConnectionCompletionHandler(ConnectionCompletionHandler connectionCompletionHandler) {
        this.connectionCompletionHandler = connectionCompletionHandler;
    }

    public void setReconnConf(ReconnConf reconnConf) {
        this.reconnConf = reconnConf;
    }

    public ReconnConf getReconnConf() {
        return this.reconnConf;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    public String toString() {
        return "TioClientConfig [name=" + this.name + "]";
    }
}

