/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.lock.LockUtils;
import org.tio.utils.lock.MapWithLock;
import org.tio.utils.lock.SetWithLock;

public class Users {
    private static Logger log = LoggerFactory.getLogger(Users.class);
    private MapWithLock<String, SetWithLock<ChannelContext>> mapWithLock = new MapWithLock(new HashMap());

    public void bind(String userid, ChannelContext channelContext) {
        if (channelContext.tioConfig.isShortConnection) {
            return;
        }
        if (StrUtil.isBlank((CharSequence)userid)) {
            return;
        }
        try {
            SetWithLock setWithLock = (SetWithLock)this.mapWithLock.get((Object)userid);
            if (setWithLock == null) {
                LockUtils.runWriteOrWaitRead((String)("_tio_users_bind__" + userid), (Object)this, () -> {
                    if (this.mapWithLock.get((Object)userid) == null) {
                        this.mapWithLock.put((Object)userid, (Object)new SetWithLock(new HashSet()));
                    }
                });
                setWithLock = (SetWithLock)this.mapWithLock.get((Object)userid);
            }
            setWithLock.add((Object)channelContext);
            channelContext.setUserid(userid);
        }
        catch (Throwable e) {
            log.error("", e);
        }
    }

    public SetWithLock<ChannelContext> find(TioConfig tioConfig, String userid) {
        if (tioConfig.isShortConnection) {
            return null;
        }
        if (StrUtil.isBlank((CharSequence)userid)) {
            return null;
        }
        return (SetWithLock)this.mapWithLock.get((Object)userid);
    }

    public MapWithLock<String, SetWithLock<ChannelContext>> getMap() {
        return this.mapWithLock;
    }

    public void unbind(ChannelContext channelContext) {
        if (channelContext.tioConfig.isShortConnection) {
            return;
        }
        String userid = channelContext.userid;
        if (StrUtil.isBlank((CharSequence)userid)) {
            log.debug("{}, {}, \u5e76\u6ca1\u6709\u7ed1\u5b9a\u7528\u6237", (Object)channelContext.tioConfig.getName(), (Object)channelContext.toString());
            return;
        }
        try {
            SetWithLock setWithLock = (SetWithLock)this.mapWithLock.get((Object)userid);
            if (setWithLock == null) {
                log.warn("{}, {}, userid:{}, \u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684SetWithLock", new Object[]{channelContext.tioConfig.getName(), channelContext.toString(), userid});
                return;
            }
            setWithLock.remove((Object)channelContext);
            if (setWithLock.size() == 0) {
                this.mapWithLock.remove((Object)userid);
            }
            channelContext.setUserid(null);
        }
        catch (Throwable e) {
            log.error(e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(TioConfig tioConfig, String userid) {
        if (tioConfig.isShortConnection) {
            return;
        }
        if (StrUtil.isBlank((CharSequence)userid)) {
            return;
        }
        try {
            ReentrantReadWriteLock.WriteLock lock = this.mapWithLock.writeLock();
            lock.lock();
            try {
                Map m = (Map)this.mapWithLock.getObj();
                SetWithLock setWithLock = (SetWithLock)m.get(userid);
                if (setWithLock == null) {
                    return;
                }
                ReentrantReadWriteLock.WriteLock writeLock = setWithLock.writeLock();
                writeLock.lock();
                try {
                    Set set = (Set)setWithLock.getObj();
                    if (set.size() > 0) {
                        for (ChannelContext channelContext : set) {
                            channelContext.setUserid(null);
                        }
                        set.clear();
                    }
                    m.remove(userid);
                    writeLock.unlock();
                }
                catch (Throwable e) {
                    try {
                        log.error(e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        writeLock.unlock();
                    }
                }
            }
            catch (Throwable e) {
                throw e;
            }
            finally {
                lock.unlock();
            }
        }
        catch (Throwable e) {
            log.error(e.toString(), e);
        }
    }
}

