/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.stat;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

public class GroupStat
implements Serializable {
    private static final long serialVersionUID = -6988655941470121164L;
    public final AtomicLong closed = new AtomicLong();
    public final AtomicLong receivedPackets = new AtomicLong();
    public final AtomicLong receivedBytes = new AtomicLong();
    public final AtomicLong handledPackets = new AtomicLong();
    public final AtomicLong handledPacketCosts = new AtomicLong();
    public final AtomicLong handledBytes = new AtomicLong();
    public final AtomicLong sentPackets = new AtomicLong();
    public final AtomicLong sentBytes = new AtomicLong();
    public final AtomicLong receivedTcps = new AtomicLong();

    public double getBytesPerTcpReceive() {
        if (this.receivedTcps.get() == 0L) {
            return 0.0;
        }
        double ret = (double)this.receivedBytes.get() / (double)this.receivedTcps.get();
        return ret;
    }

    public double getPacketsPerTcpReceive() {
        if (this.receivedTcps.get() == 0L) {
            return 0.0;
        }
        double ret = (double)this.receivedPackets.get() / (double)this.receivedTcps.get();
        return ret;
    }

    public AtomicLong getClosed() {
        return this.closed;
    }

    public AtomicLong getHandledBytes() {
        return this.handledBytes;
    }

    public AtomicLong getHandledPackets() {
        return this.handledPackets;
    }

    public AtomicLong getReceivedBytes() {
        return this.receivedBytes;
    }

    public AtomicLong getReceivedPackets() {
        return this.receivedPackets;
    }

    public AtomicLong getSentBytes() {
        return this.sentBytes;
    }

    public AtomicLong getSentPackets() {
        return this.sentPackets;
    }

    public AtomicLong getReceivedTcps() {
        return this.receivedTcps;
    }

    public AtomicLong getHandledPacketCosts() {
        return this.handledPacketCosts;
    }

    public double getHandledCostsPerPacket() {
        if (this.handledPackets.get() > 0L) {
            return this.handledPacketCosts.get() / this.handledPackets.get();
        }
        return 0.0;
    }
}

