/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousSocketChannel;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.core.TioConfig;

public class ServerChannelContext
extends ChannelContext {
    public ServerChannelContext(TioConfig tioConfig, AsynchronousSocketChannel asynchronousSocketChannel) {
        super(tioConfig, asynchronousSocketChannel);
    }

    public ServerChannelContext(TioConfig tioConfig) {
        super(tioConfig);
    }

    public ServerChannelContext(TioConfig tioConfig, String id) {
        super(tioConfig, id);
    }

    @Override
    public Node createClientNode(AsynchronousSocketChannel asynchronousSocketChannel) throws IOException {
        Node clientNode = null;
        InetSocketAddress inetSocketAddress = null;
        if (asynchronousSocketChannel == null) {
            clientNode = ServerChannelContext.createUnknowNode();
        } else {
            inetSocketAddress = (InetSocketAddress)asynchronousSocketChannel.getRemoteAddress();
        }
        if (inetSocketAddress == null) {
            clientNode = ServerChannelContext.createUnknowNode();
        }
        if (clientNode == null) {
            clientNode = new Node(inetSocketAddress.getHostString(), inetSocketAddress.getPort());
        }
        return clientNode;
    }

    @Override
    public boolean isServer() {
        return true;
    }
}

