/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.jfinal;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import org.tio.utils.jfinal.Prop;

public class P {
    private static Prop prop = null;
    private static final ConcurrentHashMap<String, Prop> map = new ConcurrentHashMap();

    private P() {
    }

    public static Prop use(String fileName) {
        return P.use(fileName, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Prop use(String fileName, String encoding) {
        Prop result = map.get(fileName);
        if (result != null) return result;
        Class<P> clazz = P.class;
        synchronized (P.class) {
            result = map.get(fileName);
            if (result != null) return result;
            result = new Prop(fileName, encoding);
            map.put(fileName, result);
            if (prop != null) return result;
            prop = result;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    public static Prop use(File file) {
        return P.use(file, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Prop use(File file, String encoding) {
        Prop result = map.get(file.getName());
        if (result != null) return result;
        Class<P> clazz = P.class;
        synchronized (P.class) {
            result = map.get(file.getName());
            if (result != null) return result;
            result = new Prop(file, encoding);
            map.put(file.getName(), result);
            if (prop != null) return result;
            prop = result;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    public static Prop useless(String fileName) {
        Prop previous = map.remove(fileName);
        if (prop == previous) {
            prop = null;
        }
        return previous;
    }

    public static void clear() {
        prop = null;
        map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Prop append(Prop prop) {
        Class<P> clazz = P.class;
        synchronized (P.class) {
            if (P.prop != null) {
                P.prop.append(prop);
            } else {
                P.prop = prop;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return P.prop;
        }
    }

    public static Prop append(String fileName, String encoding) {
        return P.append(new Prop(fileName, encoding));
    }

    public static Prop append(String fileName) {
        return P.append(fileName, "UTF-8");
    }

    public static Prop appendIfExists(String fileName, String encoding) {
        try {
            return P.append(new Prop(fileName, encoding));
        }
        catch (Exception e) {
            return prop;
        }
    }

    public static Prop appendIfExists(String fileName) {
        return P.appendIfExists(fileName, "UTF-8");
    }

    public static Prop append(File file, String encoding) {
        return P.append(new Prop(file, encoding));
    }

    public static Prop append(File file) {
        return P.append(file, "UTF-8");
    }

    public static Prop appendIfExists(File file, String encoding) {
        if (file.exists()) {
            P.append(new Prop(file, encoding));
        }
        return prop;
    }

    public static Prop appendIfExists(File file) {
        return P.appendIfExists(file, "UTF-8");
    }

    public static Prop getProp() {
        if (prop == null) {
            throw new IllegalStateException("Load propties file by invoking P.use(String fileName) method first.");
        }
        return prop;
    }

    public static Prop getProp(String fileName) {
        return map.get(fileName);
    }

    public static String get(String key) {
        return P.getProp().get(key);
    }

    public static String get(String key, String defaultValue) {
        return P.getProp().get(key, defaultValue);
    }

    public static Integer getInt(String key) {
        return P.getProp().getInt(key);
    }

    public static Integer getInt(String key, Integer defaultValue) {
        return P.getProp().getInt(key, defaultValue);
    }

    public static Long getLong(String key) {
        return P.getProp().getLong(key);
    }

    public static Long getLong(String key, Long defaultValue) {
        return P.getProp().getLong(key, defaultValue);
    }

    public static Boolean getBoolean(String key) {
        return P.getProp().getBoolean(key);
    }

    public static Boolean getBoolean(String key, Boolean defaultValue) {
        return P.getProp().getBoolean(key, defaultValue);
    }

    public static boolean containsKey(String key) {
        return P.getProp().containsKey(key);
    }
}

