/*
 * Decompiled with CFR 0.152.
 */
package org.tio.websocket.server;

import java.io.IOException;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.intf.TioUuid;
import org.tio.server.TioServer;
import org.tio.server.TioServerConfig;
import org.tio.server.intf.TioServerHandler;
import org.tio.server.intf.TioServerListener;
import org.tio.utils.Threads;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;
import org.tio.websocket.common.WsTioUuid;
import org.tio.websocket.server.WsServerConfig;
import org.tio.websocket.server.WsTioServerHandler;
import org.tio.websocket.server.WsTioServerListener;
import org.tio.websocket.server.handler.IWsMsgHandler;

public class WsServerStarter {
    private static Logger log = LoggerFactory.getLogger(WsServerStarter.class);
    private WsServerConfig wsServerConfig = null;
    private IWsMsgHandler wsMsgHandler = null;
    private WsTioServerHandler wsTioServerHandler = null;
    private WsTioServerListener wsTioServerListener = null;
    private TioServerConfig tioServerConfig = null;
    private TioServer tioServer = null;

    public TioServer getTioServer() {
        return this.tioServer;
    }

    public WsServerConfig getWsServerConfig() {
        return this.wsServerConfig;
    }

    public IWsMsgHandler getWsMsgHandler() {
        return this.wsMsgHandler;
    }

    public WsTioServerHandler getWsTioServerHandler() {
        return this.wsTioServerHandler;
    }

    public WsTioServerListener getWsTioServerListener() {
        return this.wsTioServerListener;
    }

    public TioServerConfig getTioServerConfig() {
        return this.tioServerConfig;
    }

    public WsServerStarter(int port, IWsMsgHandler wsMsgHandler) throws IOException {
        this(port, wsMsgHandler, null, null);
    }

    public WsServerStarter(int port, IWsMsgHandler wsMsgHandler, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) throws IOException {
        this(new WsServerConfig(port), wsMsgHandler, tioExecutor, groupExecutor);
    }

    public WsServerStarter(WsServerConfig wsServerConfig, IWsMsgHandler wsMsgHandler) throws IOException {
        this(wsServerConfig, wsMsgHandler, null, null);
    }

    public WsServerStarter(WsServerConfig wsServerConfig, IWsMsgHandler wsMsgHandler, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) throws IOException {
        this(wsServerConfig, wsMsgHandler, (TioUuid)new WsTioUuid(), tioExecutor, groupExecutor);
    }

    public WsServerStarter(WsServerConfig wsServerConfig, IWsMsgHandler wsMsgHandler, TioUuid tioUuid, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) throws IOException {
        if (tioExecutor == null) {
            tioExecutor = Threads.getTioExecutor();
        }
        if (groupExecutor == null) {
            groupExecutor = Threads.getGroupExecutor();
        }
        this.wsServerConfig = wsServerConfig;
        this.wsMsgHandler = wsMsgHandler;
        this.wsTioServerHandler = new WsTioServerHandler(wsServerConfig, wsMsgHandler);
        this.wsTioServerListener = new WsTioServerListener();
        this.tioServerConfig = new TioServerConfig("Tio Websocket Server", (TioServerHandler)this.wsTioServerHandler, (TioServerListener)this.wsTioServerListener, tioExecutor, groupExecutor);
        this.tioServerConfig.setHeartbeatTimeout(0L);
        this.tioServerConfig.setTioUuid(tioUuid);
        this.tioServerConfig.setReadBufferSize(30720);
        this.tioServer = new TioServer(this.tioServerConfig);
    }

    public void start() throws IOException {
        this.tioServer.start(this.wsServerConfig.getBindIp(), this.wsServerConfig.getBindPort().intValue());
    }
}

