/*
 * Decompiled with CFR 0.152.
 */
package net.dubboclub.cache;

import com.alibaba.dubbo.cache.Cache;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.serialize.ObjectInput;
import com.alibaba.dubbo.common.serialize.ObjectOutput;
import com.alibaba.dubbo.common.serialize.Serialization;
import com.alibaba.dubbo.common.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.dubboclub.cache.config.CacheConfig;

public abstract class AbstractCache
implements Cache {
    protected byte[] cacheName;
    protected URL cachedUrl;
    protected int expireSecond;
    private static final int DEFAULT_EXPIRE_SECONDS = 600;
    private static final Serialization serialization = (Serialization)ExtensionLoader.getExtensionLoader(Serialization.class).getAdaptiveExtension();
    protected static final Logger logger = LoggerFactory.getLogger(AbstractCache.class);

    protected abstract String getTagName();

    public AbstractCache(String cacheName, URL url) {
        if (StringUtils.isEmpty((String)cacheName)) {
            cacheName = "noarguments";
        }
        this.cacheName = this.objectToBytes(url, cacheName);
        this.cachedUrl = url;
        this.expireSecond = this.getExpireSecond(url);
    }

    protected byte[] objectToBytes(URL url, Object object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutput objectOutput = serialization.serialize(url, (OutputStream)byteArrayOutputStream);
            objectOutput.writeObject(object);
            objectOutput.flushBuffer();
        }
        catch (IOException e) {
            logger.error("Failed to serialize object [" + object.toString() + "] for url [" + url.toString() + "]", (Throwable)e);
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected Object bytesToObject(URL url, byte[] bytes) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        try {
            ObjectInput objectInput = serialization.deserialize(url, (InputStream)byteArrayInputStream);
            return objectInput.readObject();
        }
        catch (IOException e) {
            logger.error("Failed to deserialize bytes to object for url [" + url.toString() + "]", (Throwable)e);
            return null;
        }
        catch (ClassNotFoundException e) {
            logger.error("Failed to deserialize bytes to  object for url [" + url.toString() + "] by class not found ", (Throwable)e);
            return null;
        }
    }

    protected int getExpireSecond(URL url) {
        String prefix = "cache." + this.getTagName() + ".";
        int expireSeconds = CacheConfig.getProperty(prefix + url.getParameter("interface") + "." + url.getParameter("method") + ".expire", CacheConfig.getProperty("cache." + url.getParameter("interface") + "." + url.getParameter("method") + ".expire", CacheConfig.getProperty(prefix + url.getParameter("interface") + ".expire", CacheConfig.getProperty("cache." + url.getParameter("interface") + ".expire", CacheConfig.getProperty(prefix + "default.expire", CacheConfig.getProperty("cache.default.expire", 600))))));
        return expireSeconds;
    }

    protected byte[] generateCacheKey(Object key) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(this.objectToBytes(this.cachedUrl, key));
            byteArrayOutputStream.write(this.cacheName);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            logger.error("Failed to generate cache key for object [" + key.toString() + "]", (Throwable)e);
            return null;
        }
    }
}

