/*
 * Decompiled with CFR 0.152.
 */
package net.dubboclub.cache;

import com.alibaba.dubbo.cache.Cache;
import com.alibaba.dubbo.cache.CacheFactory;
import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.StringUtils;
import java.util.concurrent.ConcurrentHashMap;
import net.dubboclub.cache.config.CacheConfig;

public abstract class AbstractCacheFactory
implements CacheFactory {
    private ConcurrentHashMap<String, Cache> CACHE_MAP = new ConcurrentHashMap();
    private static final String DEFAULT_WHITE_REGEX = "^((select)|(get)|(query)|(load))[\\w-]*$";
    private static final String DEFAULT_BLACK_REGEX = "^((insert)|(add)|(save)|(update))[\\w-]*$";
    private static String[] cacheMethodWhiteList;
    private static String[] cacheMethodBlackList;

    protected boolean needCache(String method) {
        for (String regex : cacheMethodBlackList) {
            if (!method.matches(regex)) continue;
            return false;
        }
        for (String regex : cacheMethodWhiteList) {
            if (!method.matches(regex)) continue;
            return true;
        }
        return false;
    }

    protected String generateCacheName(URL url) {
        return url.getParameter("interface") + "." + url.getParameter("method");
    }

    public Cache getCache(URL url) {
        String method = url.getParameter("method");
        if (!this.needCache(method)) {
            return null;
        }
        String cacheName = this.generateCacheName(url);
        if (this.CACHE_MAP.containsKey(cacheName)) {
            return this.CACHE_MAP.get(cacheName);
        }
        Cache cache = this.generateNewCache(cacheName, url);
        cache = this.putCacheIfAbsent(cacheName, cache);
        return cache;
    }

    protected abstract Cache generateNewCache(String var1, URL var2);

    protected Cache putCacheIfAbsent(String cacheName, Cache cache) {
        if (this.CACHE_MAP.containsKey(cacheName)) {
            return this.CACHE_MAP.get(cacheName);
        }
        Cache oldCache = this.CACHE_MAP.putIfAbsent(cacheName, cache);
        if (oldCache == null) {
            return cache;
        }
        return oldCache;
    }

    static {
        String configWhiteList = CacheConfig.getProperty("cache.method.white.list");
        String configBlackList = CacheConfig.getProperty("cache.method.black.list");
        cacheMethodBlackList = !StringUtils.isEmpty((String)configBlackList) ? Constants.COMMA_SPLIT_PATTERN.split(configBlackList) : new String[]{DEFAULT_BLACK_REGEX};
        cacheMethodWhiteList = !StringUtils.isEmpty((String)configWhiteList) ? Constants.COMMA_SPLIT_PATTERN.split(configWhiteList) : new String[]{DEFAULT_WHITE_REGEX};
    }
}

