/*
 * Decompiled with CFR 0.152.
 */
package net.dubboclub.cache;

import com.alibaba.dubbo.common.URL;
import net.dubboclub.cache.AbstractCache;
import net.dubboclub.cache.remote.RemoteClient;

public abstract class RemoteCache
extends AbstractCache {
    protected RemoteClient remoteClient;

    public RemoteCache(String cacheName, URL url, RemoteClient remoteClient) {
        super(cacheName, url);
        this.remoteClient = remoteClient;
    }

    public void put(Object key, Object value) {
        if (value == null) {
            return;
        }
        byte[] bytes = this.generateCacheKey(key);
        if (bytes != null) {
            this.remoteClient.cacheValue(this.generateCacheKey(key), this.objectToBytes(this.cachedUrl, value), this.expireSecond);
        }
    }

    public Object get(Object key) {
        byte[] bytes = this.generateCacheKey(key);
        if (bytes != null) {
            byte[] value = this.remoteClient.getValue(bytes);
            if (value == null) {
                return null;
            }
            return this.bytesToObject(this.cachedUrl, value);
        }
        return null;
    }
}

