/*
 * Decompiled with CFR 0.152.
 */
package net.dubboclub.cache.config;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.ConfigUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

public class CacheConfig {
    private static final String CACHE_PROPERTIES_FILE = "cache.properties.file";
    private static final String CLASS_PATH_PREFIX = "classpath:";
    private static final String FILE_PATH_PREFIX = "file:";
    private static final Logger logger = LoggerFactory.getLogger(CacheConfig.class);
    private static volatile Properties properties;
    private static final String[] SUFFIXS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initProperties() {
        if (properties != null) return;
        Class<CacheConfig> clazz = CacheConfig.class;
        synchronized (CacheConfig.class) {
            if (properties != null) return;
            String cacheConfig = ConfigUtils.getProperty((String)CACHE_PROPERTIES_FILE, (String)System.getProperty(CACHE_PROPERTIES_FILE));
            try {
                properties = ConfigUtils.getProperties();
                if (StringUtils.isEmpty((String)cacheConfig)) return;
                properties = CacheConfig.loadProperties(cacheConfig);
            }
            catch (IOException e) {
                logger.error("failed to open redis config file", (Throwable)e);
            }
            return;
        }
    }

    public static Properties getProperties() {
        if (properties == null) {
            CacheConfig.initProperties();
        }
        return properties;
    }

    public static String getProperty(String key) {
        Object value = properties.get(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static String getProperty(String key, String defaultValue) {
        String value = CacheConfig.getProperty(key);
        if (!StringUtils.isEmpty((String)value)) {
            return value;
        }
        return defaultValue;
    }

    public static int getProperty(String key, int defaultValue) {
        String value = CacheConfig.getProperty(key);
        if (!StringUtils.isEmpty((String)value)) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public static short getProperty(String key, short defaultValue) {
        String value = CacheConfig.getProperty(key);
        if (!StringUtils.isEmpty((String)value)) {
            return Short.parseShort(value);
        }
        return defaultValue;
    }

    public static long getProperty(String key, long defaultValue) {
        String value = CacheConfig.getProperty(key);
        if (!StringUtils.isEmpty((String)value)) {
            return Long.parseLong(value);
        }
        return defaultValue;
    }

    public static float getProperty(String key, float defaultValue) {
        String value = CacheConfig.getProperty(key);
        if (!StringUtils.isEmpty((String)value)) {
            return Float.parseFloat(value);
        }
        return defaultValue;
    }

    public static double getProperty(String key, double defaultValue) {
        String value = CacheConfig.getProperty(key);
        if (!StringUtils.isEmpty((String)value)) {
            return Double.parseDouble(value);
        }
        return defaultValue;
    }

    public static boolean getProperty(String key, boolean defaultValue) {
        String value = CacheConfig.getProperty(key);
        if (!StringUtils.isEmpty((String)value)) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    private static Properties loadProperties(String propertyFile) throws IOException {
        InputStream inputStream = CacheConfig.getConfigurationInputStream(propertyFile);
        Properties properties = new Properties();
        properties.load(inputStream);
        return properties;
    }

    public static InputStream getConfigurationInputStream(String propertyFile) throws FileNotFoundException {
        InputStream inputStream = propertyFile.startsWith(CLASS_PATH_PREFIX) ? CacheConfig.class.getClassLoader().getResourceAsStream(propertyFile.replace(CLASS_PATH_PREFIX, "")) : (propertyFile.startsWith(FILE_PATH_PREFIX) ? new FileInputStream(new File(propertyFile.replace(FILE_PATH_PREFIX, ""))) : CacheConfig.class.getClassLoader().getResourceAsStream(propertyFile));
        return inputStream;
    }

    public static void appendProperties(Object object, Class<?> owner) {
        String prefix = "cache." + CacheConfig.getTagName(owner) + ".";
        for (Class<?> superClass = object.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = superClass.getDeclaredFields()) {
                Method setMethod = CacheConfig.getSetMethod(superClass, field);
                if (setMethod == null || !CacheConfig.checkIsBasicType(field.getType())) continue;
                String property = field.getName();
                String configValue = null;
                if (!CacheConfig.getProperties().containsKey(prefix + property)) continue;
                try {
                    configValue = CacheConfig.getProperty(prefix + property);
                    setMethod.invoke(object, CacheConfig.casePrimitiveType(field.getType(), configValue));
                }
                catch (IllegalAccessException e) {
                    logger.debug("Failed to set value [" + configValue + "] property [" + field.getName() + "] ", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    logger.debug("Failed to set value [" + configValue + "] property [" + field.getName() + "] ", (Throwable)e);
                }
            }
        }
    }

    private static String getTagName(Class<?> cls) {
        String tag = cls.getSimpleName();
        for (String suffix : SUFFIXS) {
            if (!tag.endsWith(suffix)) continue;
            tag = tag.substring(0, tag.length() - suffix.length());
            break;
        }
        tag = tag.toLowerCase();
        return tag;
    }

    protected static Object casePrimitiveType(Class<?> targetType, Object value) {
        if (value == null) {
            return null;
        }
        if (targetType == Integer.TYPE || targetType == Integer.class) {
            return Integer.parseInt(value.toString().trim());
        }
        if (targetType == Short.TYPE || targetType == Short.class) {
            return Short.parseShort(value.toString().trim());
        }
        if (targetType == Long.TYPE || targetType == Long.class) {
            return Long.parseLong(value.toString().trim());
        }
        if (targetType == Float.TYPE || targetType == Float.class) {
            return Float.valueOf(Float.parseFloat(value.toString().trim()));
        }
        if (targetType == Double.TYPE || targetType == Double.class) {
            return Double.parseDouble(value.toString().trim());
        }
        if (targetType == Boolean.TYPE || targetType == Boolean.class) {
            return Boolean.parseBoolean(value.toString().trim());
        }
        if (targetType == Character.TYPE || targetType == Character.class) {
            return Character.valueOf(value.toString().charAt(0));
        }
        if (targetType.isEnum()) {
            Class<?> enumClass = targetType;
            return Enum.valueOf(enumClass, value.toString());
        }
        return value;
    }

    private static Method getSetMethod(Class<?> clazz, Field field) {
        Method[] methods;
        StringBuffer methodName = new StringBuffer("set");
        String fieldName = field.getName();
        methodName.append(fieldName.substring(0, 1).toUpperCase()).append(fieldName.substring(1));
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName.toString())) continue;
            return method;
        }
        return null;
    }

    public static boolean checkIsBasicType(Class<?> targetType) {
        return targetType.isEnum() || targetType.isPrimitive() || String.class == targetType || targetType == Integer.class || targetType == Short.class || targetType == Long.class || targetType == Boolean.class || targetType == Double.class || targetType == Float.class || targetType == File.class || targetType == Character.class;
    }

    static {
        SUFFIXS = new String[]{"Client"};
        CacheConfig.initProperties();
    }
}

