/*
 * Decompiled with CFR 0.152.
 */
package net.dubboclub.cache.ehcache;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.StringUtils;
import java.io.FileNotFoundException;
import java.io.InputStream;
import net.dubboclub.cache.AbstractCache;
import net.dubboclub.cache.config.CacheConfig;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;

public class EhCache
extends AbstractCache {
    private static CacheManager cacheManager;
    private static final String CONFIGURATION_FILE = "cache.ehcache.configuration";
    private Ehcache originCache;

    @Override
    protected String getTagName() {
        return "ehcache";
    }

    public EhCache(String cacheName, URL url) {
        super(cacheName, url);
        this.originCache = cacheManager.addCacheIfAbsent(cacheName);
    }

    public void put(Object key, Object value) {
        if (key == null || value == null) {
            return;
        }
        Element element = new Element(key, value);
        element.setTimeToLive(this.getExpireSecond(this.cachedUrl));
        this.originCache.put(element);
    }

    public Object get(Object key) {
        Element element = this.originCache.get(key);
        if (element == null) {
            return null;
        }
        return element.getObjectValue();
    }

    static {
        if (StringUtils.isEmpty((String)CacheConfig.getProperty(CONFIGURATION_FILE))) {
            Configuration configuration = new Configuration();
            CacheConfig.appendProperties(configuration, Ehcache.class);
            CacheConfiguration cacheConfiguration = new CacheConfiguration();
            CacheConfig.appendProperties(cacheConfiguration, EhCache.class);
            if (cacheConfiguration.getMaxEntriesLocalHeap() == 0L) {
                cacheConfiguration.setMaxEntriesLocalHeap(10000L);
            }
            if (cacheConfiguration.getMaxEntriesLocalDisk() == 0L) {
                cacheConfiguration.setMaxEntriesLocalDisk(10000000L);
            }
            configuration.setDefaultCacheConfiguration(cacheConfiguration);
            cacheManager = CacheManager.create((Configuration)configuration);
        } else {
            try {
                cacheManager = CacheManager.create((InputStream)CacheConfig.getConfigurationInputStream(CacheConfig.getProperty(CONFIGURATION_FILE)));
            }
            catch (FileNotFoundException e) {
                logger.error("Failed to load configuration file", (Throwable)e);
                throw new IllegalArgumentException("Failed to load configuration file", e);
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                cacheManager.shutdown();
            }
        }));
    }
}

