/*
 * Decompiled with CFR 0.152.
 */
package net.dubboclub.cache.remote;

import com.alibaba.dubbo.common.Constants;
import com.google.code.yanf4j.config.Configuration;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeoutException;
import net.dubboclub.cache.config.CacheConfig;
import net.dubboclub.cache.remote.RemoteClient;
import net.dubboclub.cache.remote.memcached.AdaptiveMemcachedSessionLocator;
import net.rubyeye.xmemcached.MemcachedClientBuilder;
import net.rubyeye.xmemcached.MemcachedClientStateListener;
import net.rubyeye.xmemcached.MemcachedSessionLocator;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.exception.MemcachedException;
import net.rubyeye.xmemcached.utils.AddrUtil;

public class MemcachedClient
extends RemoteClient {
    private static MemcachedClientBuilder clientBuilder;
    private static volatile net.rubyeye.xmemcached.MemcachedClient client;
    private static final String MEMCACHED_CONNECT = "cache.memcached.connect";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void buildClient() {
        if (client != null && !client.isShutdown()) return;
        Class<MemcachedClient> clazz = MemcachedClient.class;
        synchronized (MemcachedClient.class) {
            if (client != null && !client.isShutdown()) return;
            try {
                client = clientBuilder.build();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to build memcached client", e);
            }
            return;
        }
    }

    @Override
    public void cacheValue(byte[] key, byte[] bytes, int expireSecond) {
        if (client.isShutdown()) {
            MemcachedClient.buildClient();
        }
        try {
            client.add(new String(key, "UTF-8"), expireSecond, (Object)bytes);
        }
        catch (TimeoutException e) {
            logger.error("Failed to add cache value by memcached", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error("Failed to add cache value by memcached", (Throwable)e);
        }
        catch (MemcachedException e) {
            logger.error("Failed to add cache value by memcached", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Failed to add cache value by memcached", (Throwable)e);
        }
    }

    @Override
    public byte[] getValue(byte[] key) {
        if (client.isShutdown()) {
            MemcachedClient.buildClient();
        }
        try {
            byte[] bytes = (byte[])client.get(new String(key, "UTF-8"));
            return bytes;
        }
        catch (TimeoutException e) {
            logger.error("Failed to get cache value from memcached", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error("Failed to get cache value from memcached", (Throwable)e);
        }
        catch (MemcachedException e) {
            logger.error("Failed to get cache value from memcached", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Failed to get cache value from memcached", (Throwable)e);
        }
        return null;
    }

    static {
        String configConnect = CacheConfig.getProperty(MEMCACHED_CONNECT);
        String[] connects = Constants.COMMA_SPLIT_PATTERN.split(configConnect);
        StringBuffer connectStr = new StringBuffer();
        if (connects.length > 0) {
            for (String connect : connects) {
                connectStr.append(connect).append(" ");
            }
            connectStr.setLength(connectStr.length() - 1);
        } else {
            connectStr.append(configConnect);
        }
        clientBuilder = new XMemcachedClientBuilder(AddrUtil.getAddresses((String)connectStr.toString()));
        CacheConfig.appendProperties(clientBuilder, MemcachedClient.class);
        clientBuilder.setSessionLocator((MemcachedSessionLocator)new AdaptiveMemcachedSessionLocator());
        Configuration configuration = new Configuration();
        CacheConfig.appendProperties(configuration, MemcachedClient.class);
        clientBuilder.setConfiguration(configuration);
        clientBuilder.addStateListener(new MemcachedClientStateListener(){

            public void onStarted(net.rubyeye.xmemcached.MemcachedClient memcachedClient) {
                RemoteClient.logger.debug("started memcached client [" + memcachedClient + "]");
            }

            public void onShutDown(net.rubyeye.xmemcached.MemcachedClient memcachedClient) {
                RemoteClient.logger.debug("shut down memcached client [" + memcachedClient + "]");
            }

            public void onConnected(net.rubyeye.xmemcached.MemcachedClient memcachedClient, InetSocketAddress inetSocketAddress) {
                RemoteClient.logger.debug("memcached client [" + memcachedClient + "] connected remote [" + inetSocketAddress + "]");
            }

            public void onDisconnected(net.rubyeye.xmemcached.MemcachedClient memcachedClient, InetSocketAddress inetSocketAddress) {
                RemoteClient.logger.debug("memcached client [" + memcachedClient + "] disconnected remote [" + inetSocketAddress + "]");
            }

            public void onException(net.rubyeye.xmemcached.MemcachedClient memcachedClient, Throwable throwable) {
                RemoteClient.logger.error("memcache client [" + memcachedClient + "] occur exception", throwable);
            }
        });
        MemcachedClient.buildClient();
    }
}

