/*
 * Decompiled with CFR 0.152.
 */
package net.dubboclub.cache.remote.memcached;

import com.alibaba.dubbo.common.extension.Adaptive;
import com.google.code.yanf4j.core.Session;
import java.util.Collection;
import net.dubboclub.cache.config.CacheConfig;
import net.rubyeye.xmemcached.MemcachedSessionLocator;
import net.rubyeye.xmemcached.impl.ArrayMemcachedSessionLocator;
import net.rubyeye.xmemcached.impl.ElectionMemcachedSessionLocator;
import net.rubyeye.xmemcached.impl.KetamaMemcachedSessionLocator;
import net.rubyeye.xmemcached.impl.LibmemcachedMemcachedSessionLocator;
import net.rubyeye.xmemcached.impl.PHPMemcacheSessionLocator;

@Adaptive
public class AdaptiveMemcachedSessionLocator
implements MemcachedSessionLocator {
    private static final String MEMCACHED_SESSION_LOCATOR = "cache.memcached.session.locator";
    private static MemcachedSessionLocator memcachedSessionLocator = SessionLocator.getSessionLocator(CacheConfig.getProperty("cache.memcached.session.locator", SessionLocator.access$000(SessionLocator.DEFAULT)));

    public Session getSessionByKey(String s) {
        return memcachedSessionLocator.getSessionByKey(s);
    }

    public void updateSessions(Collection<Session> collection) {
        memcachedSessionLocator.updateSessions(collection);
    }

    public void setFailureMode(boolean b) {
        memcachedSessionLocator.setFailureMode(b);
    }

    static enum SessionLocator {
        KETAMA("ketama", (MemcachedSessionLocator)new KetamaMemcachedSessionLocator()),
        DEFAULT("default", (MemcachedSessionLocator)new ArrayMemcachedSessionLocator()),
        ELECTION("election", (MemcachedSessionLocator)new ElectionMemcachedSessionLocator()),
        LIBMEMCACHED("libmemcached", (MemcachedSessionLocator)new LibmemcachedMemcachedSessionLocator()),
        PHP("php", (MemcachedSessionLocator)new PHPMemcacheSessionLocator());

        private String value;
        private MemcachedSessionLocator memcachedSessionLocator;

        private SessionLocator(String value, MemcachedSessionLocator memcachedSessionLocator) {
            this.value = value;
            this.memcachedSessionLocator = memcachedSessionLocator;
        }

        public static MemcachedSessionLocator getSessionLocator(String value) {
            SessionLocator[] sessionLocators;
            for (SessionLocator sessionLocator : sessionLocators = SessionLocator.values()) {
                if (!sessionLocator.value.equalsIgnoreCase(value)) continue;
                return sessionLocator.memcachedSessionLocator;
            }
            return SessionLocator.DEFAULT.memcachedSessionLocator;
        }

        static /* synthetic */ String access$000(SessionLocator x0) {
            return x0.value;
        }
    }
}

