/*
 * Decompiled with CFR 0.152.
 */
package net.dubboclub.cricuitbreaker;

import java.net.InetAddress;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import net.dubboclub.cricuitbreaker.Config;
import net.dubboclub.cricuitbreaker.ExceptionMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BreakCounter
implements Runnable {
    private static final Logger statisticsLogger = LoggerFactory.getLogger((String)"CIRCUITBREAKER-STATISTICS");
    private static final Logger logger = LoggerFactory.getLogger((String)"CIRCUITBREAKER");
    private BlockingQueue<ExceptionMarker> markerList = new LinkedBlockingQueue<ExceptionMarker>();
    private volatile AtomicLong exceptionCount = new AtomicLong(0L);
    private volatile AtomicLong circuitBreakCount = new AtomicLong(0L);
    private String invoker;
    private volatile boolean isEnable = true;
    private volatile AtomicLong retryTimes = new AtomicLong(0L);
    private static final InetAddress localAddress = Config.getLocalAddress();

    BreakCounter(String invoker) {
        this.invoker = invoker;
    }

    public void disable() {
        this.isEnable = false;
    }

    public boolean isEnable() {
        return this.isEnable;
    }

    public void addExceptionMarker(ExceptionMarker marker) {
        this.exceptionCount.incrementAndGet();
        this.markerList.offer(marker);
    }

    public void incrementRetryTimes() {
        this.retryTimes.incrementAndGet();
    }

    public long getCurrentRetryTimes() {
        return this.retryTimes.get();
    }

    public long decrementException() {
        return this.exceptionCount.decrementAndGet();
    }

    public long getCurrentExceptionCount() {
        return this.exceptionCount.get();
    }

    public long getCurrentBreakCount() {
        return this.circuitBreakCount.get();
    }

    public void incrementBreakCount() {
        this.circuitBreakCount.incrementAndGet();
    }

    @Override
    public void run() {
        if (!this.isEnable) {
            return;
        }
        Iterator markerIterator = this.markerList.iterator();
        statisticsLogger.info("[{}] checking [{}] break status,current exception times [{}] ,current break times [{}],retry times[{}]", new Object[]{localAddress, this.invoker, this.getCurrentExceptionCount(), this.getCurrentBreakCount(), this.getCurrentRetryTimes()});
        while (markerIterator.hasNext()) {
            ExceptionMarker marker = (ExceptionMarker)markerIterator.next();
            logger.info("[{}] checking [{}] break marker whether expired  break at [{}],remain  [{}],case[{}]", new Object[]{localAddress, this.invoker, marker.getBreakTime(), marker.getRemain(), marker.getCaseByMessage()});
            if (!marker.isExpire()) continue;
            markerIterator.remove();
            this.decrementException();
        }
    }
}

