/*
 * Decompiled with CFR 0.152.
 */
package net.dubboclub.cricuitbreaker;

import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.dubboclub.cricuitbreaker.BreakCounter;

class BreakCounterLoop
extends Thread {
    private long intervalTime;
    private BlockingQueue<BreakCounter> queue = new LinkedBlockingQueue<BreakCounter>();
    private volatile boolean started = false;
    private Object startLock = new Object();

    BreakCounterLoop(long intervalTime) {
        this.setDaemon(true);
        this.intervalTime = intervalTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(BreakCounter counter) {
        this.queue.offer(counter);
        Object object = this.startLock;
        synchronized (object) {
            if (!this.started) {
                this.start();
                this.started = true;
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            Iterator iterator = this.queue.iterator();
            while (iterator.hasNext()) {
                BreakCounter counter = (BreakCounter)iterator.next();
                if (counter.isEnable()) {
                    counter.run();
                    continue;
                }
                iterator.remove();
            }
            try {
                Thread.sleep(this.intervalTime);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

