/*
 * Decompiled with CFR 0.152.
 */
package net.dubboclub.cricuitbreaker;

import com.alibaba.dubbo.common.utils.ConfigUtils;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import java.net.InetAddress;
import org.apache.commons.lang.StringUtils;

public class Config {
    private static final String DEFAULT_BREAK_LIMIT = "10";
    private static final String DEFAULT_RETRY_FREQUENCY = "10";
    protected static final String DUBBO_REFERENCE_PREFIX = "dubbo.reference.";
    private static final String DUBBO_REFERENCE_CIRCUIT_BREAKER_SWITCH = "dubbo.reference.circuit.breaker";

    public static boolean checkFunctionSwitch(Invoker<?> invoker, Invocation invocation) {
        String circuitBreak = invoker.getUrl().getMethodParameter(invocation.getMethodName(), "circuit.break");
        if (StringUtils.isEmpty((String)circuitBreak)) {
            String interfaceName = invoker.getUrl().getParameter("interface");
            String method = invocation.getMethodName();
            StringBuffer interfaceConfig = new StringBuffer(DUBBO_REFERENCE_PREFIX);
            interfaceConfig.append(interfaceName);
            StringBuffer methodConfig = new StringBuffer(interfaceConfig.toString());
            methodConfig.append(".").append(method);
            return Config.getSwitch(interfaceConfig, methodConfig);
        }
        return Boolean.parseBoolean(StringUtils.trim((String)circuitBreak));
    }

    public static int getBreakLimit(Invoker<?> invoker, Invocation invocation) {
        String dynamicConfig = invoker.getUrl().getMethodParameter(invocation.getMethodName(), "break.limit");
        if (StringUtils.isEmpty((String)dynamicConfig)) {
            return Config.getBreakLimit(Config.getInterfacePropertyName(invoker), Config.getMethodPropertyName(invoker, invocation));
        }
        int limit = Integer.parseInt(dynamicConfig);
        int retries = invoker.getUrl().getParameter("retries", 2);
        return limit * ++retries;
    }

    public static StringBuffer getInterfacePropertyName(Invoker<?> invoker) {
        String interfaceName = invoker.getUrl().getParameter("interface");
        StringBuffer interfaceConfig = new StringBuffer(DUBBO_REFERENCE_PREFIX);
        interfaceConfig.append(interfaceName);
        return interfaceConfig;
    }

    public static StringBuffer getMethodPropertyName(Invoker<?> invoker, Invocation invocation) {
        String interfaceName = invoker.getUrl().getParameter("interface");
        String method = invocation.getMethodName();
        StringBuffer interfaceConfig = new StringBuffer(DUBBO_REFERENCE_PREFIX);
        interfaceConfig.append(interfaceName);
        StringBuffer methodConfig = new StringBuffer(interfaceConfig.toString());
        methodConfig.append(".").append(method);
        return methodConfig;
    }

    public static InetAddress getLocalAddress() {
        return NetUtils.getLocalAddress();
    }

    public static int getBreakLimit(StringBuffer interfaceConfig, StringBuffer methodConfig) {
        methodConfig.append(".break.limit");
        interfaceConfig.append(".break.limit");
        String breakLimitConf = ConfigUtils.getProperty((String)methodConfig.toString(), (String)ConfigUtils.getProperty((String)interfaceConfig.toString(), (String)ConfigUtils.getProperty((String)"dubbo.reference.default.break.limit", (String)"10")));
        return Integer.parseInt(breakLimitConf);
    }

    public static boolean getSwitch(StringBuffer interfaceConfig, StringBuffer methodConfig) {
        methodConfig.append(".circuit.break");
        interfaceConfig.append(".circuit.break");
        String switchConfig = ConfigUtils.getProperty((String)methodConfig.toString(), (String)ConfigUtils.getProperty((String)interfaceConfig.toString(), (String)ConfigUtils.getProperty((String)"dubbo.reference.circuit.break", (String)"false")));
        return Boolean.parseBoolean(switchConfig);
    }

    public static int getRetryFrequency(Invoker<?> invoker, Invocation invocation) {
        String retryFrequency = invoker.getUrl().getMethodParameter(invocation.getMethodName(), "retry.frequency");
        if (StringUtils.isEmpty((String)retryFrequency)) {
            return Config.getRetryFrequency(Config.getInterfacePropertyName(invoker), Config.getMethodPropertyName(invoker, invocation));
        }
        return Integer.parseInt(retryFrequency);
    }

    public static int getRetryFrequency(StringBuffer interfaceConfig, StringBuffer methodConfig) {
        methodConfig.append(".retry.frequency");
        interfaceConfig.append(".retry.frequency");
        String retryFrequencyConf = ConfigUtils.getProperty((String)methodConfig.toString(), (String)ConfigUtils.getProperty((String)interfaceConfig.toString(), (String)ConfigUtils.getProperty((String)"dubbo.reference.default.retry.frequency", (String)"10")));
        return Integer.parseInt(retryFrequencyConf);
    }
}

