/*
 * Decompiled with CFR 0.152.
 */
package net.dubboclub.cricuitbreaker;

import java.util.Date;

class ExceptionMarker {
    private long breakTime;
    private long expireTime;
    private Date breakDate;
    private Throwable breakBy;
    private String caseByMessage;

    public String getCaseByMessage() {
        return this.caseByMessage;
    }

    ExceptionMarker(long breakTime, long expireTime, Throwable breakBy) {
        this.breakTime = breakTime;
        this.expireTime = expireTime;
        this.breakDate = new Date(breakTime);
        this.breakBy = breakBy;
        this.caseByMessage = breakBy.getMessage();
    }

    public String toString() {
        StringBuffer toString = new StringBuffer("breakTime=");
        toString.append(this.breakDate).append(",expireTime=" + this.expireTime + "ms,remain " + this.getRemain() + "ms, break by " + this.breakBy.getMessage());
        return toString.toString();
    }

    public long getRemain() {
        return this.getExpireTime() - (System.currentTimeMillis() - this.breakTime);
    }

    public long getBreakTime() {
        return this.breakTime;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public boolean isExpire() {
        return System.currentTimeMillis() - this.getBreakTime() >= this.getExpireTime();
    }
}

