/*
 * Decompiled with CFR 0.152.
 */
package net.dubboclub.cricuitbreaker;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.utils.ConfigUtils;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.ProxyFactory;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import java.net.InetAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import net.dubboclub.cricuitbreaker.BreakCounter;
import net.dubboclub.cricuitbreaker.BreakCounterLoop;
import net.dubboclub.cricuitbreaker.Config;
import net.dubboclub.cricuitbreaker.ExceptionMarker;
import net.dubboclub.cricuitbreaker.exception.CircuitBreakerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"consumer"})
public class RemoteFacadeCircuitBreaker
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger((String)"CIRCUITBREAKER");
    private static final InetAddress localHost = Config.getLocalAddress();
    private volatile ConcurrentHashMap<String, BreakCounter> breakCounterMap = new ConcurrentHashMap();
    private BreakCounterLoop[] breakCounterLoops = new BreakCounterLoop[Runtime.getRuntime().availableProcessors()];
    private static final ProxyFactory proxyFactory = (ProxyFactory)ExtensionLoader.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
    private static final ConcurrentHashMap<String, Invoker> CIRCUIT_BREAKER_INVOKER_CACHE = new ConcurrentHashMap();
    private volatile AtomicLong loopCount = new AtomicLong(0L);

    public RemoteFacadeCircuitBreaker() {
        String intervalConf = ConfigUtils.getProperty((String)"dubbo.reference.check.break.marker.interval", (String)"60000");
        logger.info("[{}] has already been initialized circuit breaker,check break marker interval [{}]", (Object)localHost, (Object)intervalConf);
        long interval = Long.parseLong(intervalConf);
        for (int i = 0; i < this.breakCounterLoops.length; ++i) {
            BreakCounterLoop loop;
            this.breakCounterLoops[i] = loop = new BreakCounterLoop(interval);
        }
    }

    private BreakCounterLoop nextLoop() {
        return this.breakCounterLoops[(int)(this.loopCount.incrementAndGet() % (long)this.breakCounterLoops.length)];
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (Config.checkFunctionSwitch(invoker, invocation)) {
            logger.info("[{}] had [{}] breaker", (Object)localHost, (Object)this.breakCounterMap.size());
            return this.wrapBreakerInvoke(invoker, invocation);
        }
        Result result = invoker.invoke(invocation);
        this.toBeNormal(invoker, invocation);
        return result;
    }

    private Result wrapBreakerInvoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (this.checkNeedCircuitBreak(invoker, invocation)) {
            logger.info("[{}] activate the circuit break for url [{}],invoke method [{}]", new Object[]{localHost, invoker.getUrl(), invocation.getMethodName()});
            return this.doCircuitBreak(invoker, invocation);
        }
        try {
            Result result = invoker.invoke(invocation);
            this.toBeNormal(invoker, invocation);
            return result;
        }
        catch (RpcException e) {
            if (!e.isBiz()) {
                this.caughtException(invoker, invocation, (Exception)((Object)e));
            }
            throw e;
        }
    }

    private void toBeNormal(Invoker<?> invoker, Invocation invocation) {
        String interfaceName = invoker.getUrl().getParameter("interface");
        String method = invocation.getMethodName();
        StringBuffer methodConfig = new StringBuffer("dubbo.reference.");
        methodConfig.append(interfaceName).append(".").append(method);
        String methodKey = methodConfig.toString();
        BreakCounter counter = this.breakCounterMap.remove(methodKey);
        if (counter != null) {
            logger.info("[{}] [{}.{}] to be normal", new Object[]{localHost, interfaceName, methodKey});
            counter.disable();
        }
    }

    private boolean checkNeedCircuitBreak(Invoker<?> invoker, Invocation invocation) {
        String interfaceName = invoker.getUrl().getParameter("interface");
        String method = invocation.getMethodName();
        String methodKey = Config.getMethodPropertyName(invoker, invocation).toString();
        int limit = Config.getBreakLimit(invoker, invocation);
        BreakCounter breakCounter = this.breakCounterMap.get(methodKey);
        if (breakCounter != null && breakCounter.isEnable()) {
            long currentExceptionCount = breakCounter.getCurrentExceptionCount();
            long currentBreakCount = breakCounter.getCurrentBreakCount();
            logger.info("[{}] check invoke [{}.{}] circuit break,current exception count [{}]  limit [{}]", new Object[]{localHost, interfaceName, method, currentExceptionCount, limit});
            if ((long)limit <= currentExceptionCount) {
                if (currentBreakCount > 0L && this.needRetry(invoker, invocation, currentBreakCount)) {
                    logger.info("[{}] retry invoke [{}.{}] current break count [{}]", new Object[]{localHost, interfaceName, method, currentBreakCount});
                    breakCounter.incrementRetryTimes();
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean needRetry(Invoker<?> invoker, Invocation invocation, long currentBreakCount) {
        String interfaceName = invoker.getUrl().getParameter("interface");
        String method = invocation.getMethodName();
        int frequency = Config.getRetryFrequency(invoker, invocation);
        logger.info("[{}] check invoke [{}.{}] need retry,current break count [{}],retry frequency [{}]", new Object[]{localHost, interfaceName, method, currentBreakCount, frequency});
        if (currentBreakCount % (long)frequency == 0L) {
            logger.info("[{}] retry invoke [{}.{}]", new Object[]{localHost, interfaceName, method});
            return true;
        }
        return false;
    }

    private <T> Result doCircuitBreak(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String interfaceName = invoker.getUrl().getParameter("interface");
        String circuitBreaker = interfaceName + "CircuitBreak";
        this.incrementBreakCount(invoker, invocation);
        try {
            logger.info("[{}] check has class [{}] to handle circuit break", (Object)localHost, (Object)circuitBreaker);
            Invoker breakerInvoker = null;
            if (CIRCUIT_BREAKER_INVOKER_CACHE.containsKey(circuitBreaker)) {
                breakerInvoker = CIRCUIT_BREAKER_INVOKER_CACHE.get(circuitBreaker);
            } else {
                Class<?> breakerType = Class.forName(circuitBreaker);
                Class<?> interfaceType = Class.forName(interfaceName);
                if (interfaceType.isAssignableFrom(breakerType)) {
                    logger.info("[{}] handle circuit break by class [{}]", (Object)localHost, (Object)circuitBreaker);
                    Object breaker = breakerType.newInstance();
                    breakerInvoker = proxyFactory.getInvoker(breaker, interfaceType, invoker.getUrl());
                    Invoker oldInvoker = CIRCUIT_BREAKER_INVOKER_CACHE.putIfAbsent(circuitBreaker, breakerInvoker);
                    if (oldInvoker != null) {
                        breakerInvoker = oldInvoker;
                    }
                }
            }
            if (breakerInvoker != null) {
                return breakerInvoker.invoke(invocation);
            }
        }
        catch (Exception e) {
            logger.error("failed to invoke circuit breaker", (Throwable)e);
        }
        logger.info("[{}] handle circuit break by exception", (Object)localHost);
        CircuitBreakerException baseBusinessException = new CircuitBreakerException(interfaceName, invocation.getMethodName());
        throw baseBusinessException;
    }

    private void incrementBreakCount(Invoker<?> invoker, Invocation invocation) {
        String interfaceName = invoker.getUrl().getParameter("interface");
        String method = invocation.getMethodName();
        StringBuffer interfaceConfig = new StringBuffer("dubbo.reference.");
        interfaceConfig.append(interfaceName);
        StringBuffer methodConfig = new StringBuffer(interfaceConfig.toString());
        methodConfig.append(".").append(method);
        String methodKey = methodConfig.toString();
        BreakCounter counter = this.breakCounterMap.get(methodKey);
        counter.incrementBreakCount();
    }

    private void caughtException(Invoker<?> invoker, Invocation invocation, Exception e) {
        BreakCounter oldValue;
        String interfaceName = invoker.getUrl().getParameter("interface");
        String method = invocation.getMethodName();
        StringBuffer interfaceConfig = new StringBuffer("dubbo.reference.");
        interfaceConfig.append(interfaceName);
        StringBuffer methodConfig = new StringBuffer(interfaceConfig.toString());
        methodConfig.append(".").append(method);
        String methodKey = methodConfig.toString();
        int timeout = invoker.getUrl().getMethodParameter(invocation.getMethodName(), "timeout", 1000);
        int limit = Config.getBreakLimit(invoker, invocation);
        ExceptionMarker breakMarker = new ExceptionMarker(System.currentTimeMillis(), limit * timeout, e);
        if (!this.breakCounterMap.containsKey(methodKey) && (oldValue = this.breakCounterMap.putIfAbsent(methodKey, new BreakCounter(methodKey))) == null) {
            this.nextLoop().register(this.breakCounterMap.get(methodKey));
        }
        BreakCounter counter = this.breakCounterMap.get(methodKey);
        counter.addExceptionMarker(breakMarker);
        logger.info("[{}] caught exception for rpc invoke [{}.{}],current exception count [{}]", new Object[]{localHost, interfaceName, method, counter.getCurrentExceptionCount()});
    }
}

