/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities.mixin.channel.middleman;

import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.BaseGuildMessageChannel;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.api.requests.restaction.WebhookAction;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.EntityBuilder;
import net.dv8tion.jda.internal.entities.WebhookImpl;
import net.dv8tion.jda.internal.entities.mixin.channel.attribute.ICategorizableChannelMixin;
import net.dv8tion.jda.internal.entities.mixin.channel.attribute.IInviteContainerMixin;
import net.dv8tion.jda.internal.entities.mixin.channel.attribute.IPermissionContainerMixin;
import net.dv8tion.jda.internal.entities.mixin.channel.attribute.IPositionableChannelMixin;
import net.dv8tion.jda.internal.entities.mixin.channel.attribute.IThreadContainerMixin;
import net.dv8tion.jda.internal.entities.mixin.channel.middleman.GuildMessageChannelMixin;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.restaction.AuditableRestActionImpl;
import net.dv8tion.jda.internal.requests.restaction.WebhookActionImpl;
import net.dv8tion.jda.internal.utils.Checks;

public interface BaseGuildMessageChannelMixin<T extends BaseGuildMessageChannelMixin<T>>
extends BaseGuildMessageChannel,
GuildMessageChannelMixin<T>,
IThreadContainerMixin<T>,
ICategorizableChannelMixin<T>,
IPositionableChannelMixin<T>,
IPermissionContainerMixin<T>,
IInviteContainerMixin<T> {
    @Override
    default public boolean canTalk(@Nonnull Member member) {
        if (!this.getGuild().equals(member.getGuild())) {
            throw new IllegalArgumentException("Provided Member is not from the Guild that this NewsChannel is part of.");
        }
        return member.hasPermission((GuildChannel)this, Permission.VIEW_CHANNEL, Permission.MESSAGE_SEND);
    }

    @Override
    @Nonnull
    default public RestAction<List<Webhook>> retrieveWebhooks() {
        this.checkPermission(Permission.MANAGE_WEBHOOKS);
        Route.CompiledRoute route = Route.Channels.GET_WEBHOOKS.compile(this.getId());
        JDAImpl jda = (JDAImpl)this.getJDA();
        return new RestActionImpl<List<Webhook>>((JDA)jda, route, (response, request) -> {
            DataArray array = response.getArray();
            ArrayList<WebhookImpl> webhooks = new ArrayList<WebhookImpl>(array.length());
            EntityBuilder builder = jda.getEntityBuilder();
            for (int i = 0; i < array.length(); ++i) {
                try {
                    webhooks.add(builder.createWebhook(array.getObject(i)));
                    continue;
                }
                catch (UncheckedIOException | NullPointerException e) {
                    JDAImpl.LOG.error("Error while creating websocket from json", (Throwable)e);
                }
            }
            return Collections.unmodifiableList(webhooks);
        });
    }

    @Override
    @Nonnull
    default public WebhookAction createWebhook(@Nonnull String name) {
        Checks.notBlank(name, "Webhook name");
        name = name.trim();
        Checks.notEmpty(name, "Name");
        Checks.notLonger(name, 100, "Name");
        this.checkPermission(Permission.MANAGE_WEBHOOKS);
        return new WebhookActionImpl(this.getJDA(), this, name);
    }

    @Override
    @Nonnull
    default public AuditableRestAction<Void> deleteWebhookById(@Nonnull String id) {
        Checks.isSnowflake(id, "Webhook ID");
        this.checkPermission(Permission.MANAGE_WEBHOOKS);
        Route.CompiledRoute route = Route.Webhooks.DELETE_WEBHOOK.compile(id);
        return new AuditableRestActionImpl<Void>(this.getJDA(), route);
    }

    public T setTopic(String var1);

    public T setNSFW(boolean var1);
}

