/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.utils;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.utils.AttachmentUpdate;
import net.dv8tion.jda.api.utils.FileUpload;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.api.utils.data.DataObject;
import okhttp3.MultipartBody;

public interface AttachedFile
extends Closeable {
    @Nonnull
    public static FileUpload fromData(@Nonnull InputStream data, @Nonnull String name) {
        return FileUpload.fromData(data, name);
    }

    @Nonnull
    public static FileUpload fromData(@Nonnull byte[] data, @Nonnull String name) {
        return FileUpload.fromData(data, name);
    }

    @Nonnull
    public static FileUpload fromData(@Nonnull File file, @Nonnull String name) {
        return FileUpload.fromData(file, name);
    }

    @Nonnull
    public static FileUpload fromData(@Nonnull File file) {
        return FileUpload.fromData(file);
    }

    @Nonnull
    public static FileUpload fromData(@Nonnull Path path, @Nonnull String name, OpenOption ... options) {
        return FileUpload.fromData(path, name, options);
    }

    @Nonnull
    public static FileUpload fromData(@Nonnull Path path, OpenOption ... options) {
        return FileUpload.fromData(path, options);
    }

    @Nonnull
    public static AttachmentUpdate fromAttachment(long id) {
        return AttachmentUpdate.fromAttachment(id);
    }

    @Nonnull
    public static AttachmentUpdate fromAttachment(@Nonnull String id) {
        return AttachmentUpdate.fromAttachment(id);
    }

    @Nonnull
    public static AttachmentUpdate fromAttachment(@Nonnull Message.Attachment attachment) {
        return AttachmentUpdate.fromAttachment(attachment);
    }

    public void addPart(@Nonnull MultipartBody.Builder var1, int var2);

    @Nonnull
    public DataObject toAttachmentData(int var1);

    @Nonnull
    public static MultipartBody.Builder createMultipartBody(@Nonnull List<? extends AttachedFile> files, @Nullable DataObject payloadJson) {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        DataArray descriptors = DataArray.empty();
        for (int i = 0; i < files.size(); ++i) {
            AttachedFile file = files.get(i);
            file.addPart(builder, i);
            descriptors.add(file.toAttachmentData(i));
        }
        if (payloadJson == null) {
            return builder;
        }
        payloadJson.put("attachments", descriptors);
        builder.addFormDataPart("payload_json", payloadJson.toString());
        return builder;
    }
}

