/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.handle;

import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.channel.IGuildChannelContainer;
import net.dv8tion.jda.api.events.message.react.MessageReactionRemoveAllEvent;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.handle.EventCache;
import net.dv8tion.jda.internal.handle.SocketHandler;
import net.dv8tion.jda.internal.requests.WebSocketClient;

public class MessageReactionBulkRemoveHandler
extends SocketHandler {
    public MessageReactionBulkRemoveHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        MessageChannel channel;
        long messageId = content.getLong("message_id");
        long channelId = content.getLong("channel_id");
        JDAImpl jda = this.getJDA();
        IGuildChannelContainer guild = null;
        if (!content.isNull("guild_id")) {
            long guildId = content.getUnsignedLong("guild_id");
            if (this.api.getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
            guild = this.api.getGuildById(guildId);
            if (guild == null) {
                EventCache.LOG.debug("Caching MESSAGE_REACTION_REMOVE_ALL event for guild that is not currently cached. GuildID: {}", (Object)guildId);
                this.api.getEventCache().cache(EventCache.Type.GUILD, guildId, this.responseNumber, this.allContent, this::handle);
                return null;
            }
        }
        if ((channel = this.getJDA().getChannelById(MessageChannel.class, channelId)) == null) {
            GuildChannel guildChannel;
            if (guild != null && (guildChannel = guild.getGuildChannelById(channelId)) != null) {
                WebSocketClient.LOG.debug("Discarding MESSAGE_REACTION_REMOVE_ALL event for unexpected channel type. Channel: {}", (Object)guildChannel);
                return null;
            }
            jda.getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("Received a reaction for a channel that JDA does not currently have cached channel_id: {} message_id: {}", (Object)channelId, (Object)messageId);
            return null;
        }
        jda.handleEvent(new MessageReactionRemoveAllEvent(jda, this.responseNumber, messageId, channel));
        return null;
    }
}

