/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.interactions;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.DefaultMemberPermissions;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandGroupData;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.utils.Checks;

public class CommandDataImpl
implements SlashCommandData {
    protected final DataArray options = DataArray.empty();
    protected String name;
    protected String description = "";
    private boolean allowSubcommands = true;
    private boolean allowGroups = true;
    private boolean allowOption = true;
    private boolean allowRequired = true;
    private boolean guildOnly = false;
    private DefaultMemberPermissions defaultMemberPermissions = DefaultMemberPermissions.ENABLED;
    private final Command.Type type;

    public CommandDataImpl(@Nonnull String name, @Nonnull String description) {
        this.type = Command.Type.SLASH;
        this.setName(name);
        this.setDescription(description);
    }

    public CommandDataImpl(@Nonnull Command.Type type, @Nonnull String name) {
        this.type = type;
        Checks.notNull((Object)type, "Command Type");
        Checks.check(type != Command.Type.SLASH, "Cannot create slash command without description. Use `new CommandDataImpl(name, description)` instead.");
        this.setName(name);
    }

    protected void checkType(Command.Type required, String action) {
        if (required != this.type) {
            throw new IllegalStateException("Cannot " + action + " for commands of type " + (Object)((Object)this.type));
        }
    }

    @Override
    @Nonnull
    public DataObject toData() {
        DataObject json = DataObject.empty().put("type", this.type.getId()).put("name", this.name).put("options", this.options).put("dm_permission", !this.guildOnly).put("default_member_permissions", this.defaultMemberPermissions == DefaultMemberPermissions.ENABLED ? null : Long.toUnsignedString(this.defaultMemberPermissions.getPermissionsRaw()));
        if (this.type == Command.Type.SLASH) {
            json.put("description", this.description);
        }
        return json;
    }

    @Override
    @Nonnull
    public Command.Type getType() {
        return this.type;
    }

    @Override
    @Nonnull
    public DefaultMemberPermissions getDefaultPermissions() {
        return this.defaultMemberPermissions;
    }

    @Override
    public boolean isGuildOnly() {
        return this.guildOnly;
    }

    @Override
    @Nonnull
    public List<SubcommandData> getSubcommands() {
        return this.options.stream(DataArray::getObject).filter(obj -> {
            OptionType type = OptionType.fromKey(obj.getInt("type"));
            return type == OptionType.SUB_COMMAND;
        }).map(SubcommandData::fromData).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public List<SubcommandGroupData> getSubcommandGroups() {
        return this.options.stream(DataArray::getObject).filter(obj -> {
            OptionType type = OptionType.fromKey(obj.getInt("type"));
            return type == OptionType.SUB_COMMAND_GROUP;
        }).map(SubcommandGroupData::fromData).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public CommandDataImpl setDefaultPermissions(@Nonnull DefaultMemberPermissions permissions) {
        Checks.notNull(permissions, "Permissions");
        this.defaultMemberPermissions = permissions;
        return this;
    }

    @Override
    @Nonnull
    public CommandDataImpl setGuildOnly(boolean guildOnly) {
        this.guildOnly = guildOnly;
        return this;
    }

    @Override
    @Nonnull
    public CommandDataImpl addOptions(OptionData ... options) {
        Checks.noneNull(options, "Option");
        if (options.length == 0) {
            return this;
        }
        this.checkType(Command.Type.SLASH, "add options");
        Checks.check(options.length + this.options.length() <= 25, "Cannot have more than 25 options for a command!");
        Checks.check(this.allowOption, "You cannot mix options with subcommands/groups.");
        boolean allowRequired = this.allowRequired;
        for (OptionData option : options) {
            Checks.check(option.getType() != OptionType.SUB_COMMAND, "Cannot add a subcommand with addOptions(...). Use addSubcommands(...) instead!");
            Checks.check(option.getType() != OptionType.SUB_COMMAND_GROUP, "Cannot add a subcommand group with addOptions(...). Use addSubcommandGroups(...) instead!");
            Checks.check(allowRequired || !option.isRequired(), "Cannot add required options after non-required options!");
            allowRequired = option.isRequired();
        }
        Checks.checkUnique(Stream.concat(this.getOptions().stream(), Arrays.stream(options)).map(OptionData::getName), "Cannot have multiple options with the same name. Name: \"%s\" appeared %d times!", (count, value) -> new Object[]{value, count});
        this.allowGroups = false;
        this.allowSubcommands = false;
        this.allowRequired = allowRequired;
        for (OptionData option : options) {
            this.options.add(option);
        }
        return this;
    }

    @Override
    @Nonnull
    public CommandDataImpl addSubcommands(SubcommandData ... subcommands) {
        Checks.noneNull(subcommands, "Subcommands");
        if (subcommands.length == 0) {
            return this;
        }
        this.checkType(Command.Type.SLASH, "add subcommands");
        if (!this.allowSubcommands) {
            throw new IllegalArgumentException("You cannot mix options with subcommands/groups.");
        }
        Checks.check(subcommands.length + this.options.length() <= 25, "Cannot have more than 25 subcommands for a command!");
        Checks.checkUnique(Stream.concat(this.getSubcommands().stream(), Arrays.stream(subcommands)).map(SubcommandData::getName), "Cannot have multiple subcommands with the same name. Name: \"%s\" appeared %d times!", (count, value) -> new Object[]{value, count});
        this.allowOption = false;
        for (SubcommandData data : subcommands) {
            this.options.add(data);
        }
        return this;
    }

    @Override
    @Nonnull
    public CommandDataImpl addSubcommandGroups(SubcommandGroupData ... groups) {
        Checks.noneNull(groups, "SubcommandGroups");
        if (groups.length == 0) {
            return this;
        }
        this.checkType(Command.Type.SLASH, "add subcommand groups");
        if (!this.allowGroups) {
            throw new IllegalArgumentException("You cannot mix options with subcommands/groups.");
        }
        Checks.check(groups.length + this.options.length() <= 25, "Cannot have more than 25 subcommand groups for a command!");
        Checks.checkUnique(Stream.concat(this.getSubcommandGroups().stream(), Arrays.stream(groups)).map(SubcommandGroupData::getName), "Cannot have multiple subcommand groups with the same name. Name: \"%s\" appeared %d times!", (count, value) -> new Object[]{value, count});
        this.allowOption = false;
        for (SubcommandGroupData data : groups) {
            this.options.add(data);
        }
        return this;
    }

    @Override
    @Nonnull
    public CommandDataImpl setName(@Nonnull String name) {
        Checks.inRange(name, 1, 32, "Name");
        if (this.type == Command.Type.SLASH) {
            Checks.matches(name, Checks.ALPHANUMERIC_WITH_DASH, "Name");
            Checks.isLowercase(name, "Name");
        }
        this.name = name;
        return this;
    }

    @Override
    @Nonnull
    public CommandDataImpl setDescription(@Nonnull String description) {
        this.checkType(Command.Type.SLASH, "set description");
        Checks.notEmpty(description, "Description");
        Checks.notLonger(description, 100, "Description");
        this.description = description;
        return this;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nonnull
    public List<OptionData> getOptions() {
        return this.options.stream(DataArray::getObject).map(OptionData::fromData).filter(it -> it.getType().getKey() > OptionType.SUB_COMMAND_GROUP.getKey()).collect(Collectors.toList());
    }
}

