/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities;

import javax.annotation.Nonnull;

public enum MessageType {
    DEFAULT(0, false, true),
    RECIPIENT_ADD(1, true, false),
    RECIPIENT_REMOVE(2, true, false),
    CALL(3, true, false),
    CHANNEL_NAME_CHANGE(4, true, false),
    CHANNEL_ICON_CHANGE(5, true, false),
    CHANNEL_PINNED_ADD(6, true, true),
    GUILD_MEMBER_JOIN(7, true, true),
    GUILD_MEMBER_BOOST(8, true, true),
    GUILD_BOOST_TIER_1(9, true, true),
    GUILD_BOOST_TIER_2(10, true, true),
    GUILD_BOOST_TIER_3(11, true, true),
    CHANNEL_FOLLOW_ADD(12, true, true),
    GUILD_DISCOVERY_DISQUALIFIED(14, true, false),
    GUILD_DISCOVERY_REQUALIFIED(15, true, false),
    GUILD_DISCOVERY_GRACE_PERIOD_INITIAL_WARNING(16, true, false),
    GUILD_DISCOVERY_GRACE_PERIOD_FINAL_WARNING(17, true, false),
    THREAD_CREATED(18, true, true),
    INLINE_REPLY(19, false, true),
    SLASH_COMMAND(20, false, true),
    THREAD_STARTER_MESSAGE(21, false, false),
    GUILD_INVITE_REMINDER(22, true, true),
    CONTEXT_COMMAND(23, false, true),
    AUTO_MODERATION_ACTION(24, true, true),
    UNKNOWN(-1, false, true);

    private final int id;
    private final boolean system;
    private final boolean deletable;

    private MessageType(int id, boolean system, boolean deletable) {
        this.id = id;
        this.system = system;
        this.deletable = deletable;
    }

    public int getId() {
        return this.id;
    }

    public boolean isSystem() {
        return this.system;
    }

    public boolean canDelete() {
        return this.deletable;
    }

    @Nonnull
    public static MessageType fromId(int id) {
        for (MessageType type : MessageType.values()) {
            if (type.id != id) continue;
            return type;
        }
        return UNKNOWN;
    }
}

