/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.interactions.components.selections;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.ComponentInteraction;
import net.dv8tion.jda.api.interactions.components.ItemComponent;
import net.dv8tion.jda.api.interactions.components.LayoutComponent;
import net.dv8tion.jda.api.interactions.components.selections.SelectMenu;
import net.dv8tion.jda.api.interactions.components.selections.SelectOption;
import net.dv8tion.jda.api.requests.RestAction;

public interface SelectMenuInteraction
extends ComponentInteraction {
    @Override
    @Nonnull
    public SelectMenu getComponent();

    @Nonnull
    default public SelectMenu getSelectMenu() {
        return this.getComponent();
    }

    @Nonnull
    default public List<SelectOption> getSelectedOptions() {
        SelectMenu menu = this.getComponent();
        List<String> values = this.getValues();
        return menu.getOptions().stream().filter(it -> values.contains(it.getValue())).collect(Collectors.toList());
    }

    @Nonnull
    public List<String> getValues();

    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> editSelectMenu(@Nullable SelectMenu newMenu) {
        Message message = this.getMessage();
        ArrayList<ActionRow> components = new ArrayList<ActionRow>(message.getActionRows());
        LayoutComponent.updateComponent(components, this.getComponentId(), (ItemComponent)newMenu);
        if (this.isAcknowledged()) {
            return this.getHook().editMessageComponentsById(message.getId(), components).map(it -> null);
        }
        return this.editComponents(components).map(it -> null);
    }
}

