/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities.channel.concrete;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.channel.attribute.IAgeRestrictedChannel;
import net.dv8tion.jda.api.entities.channel.attribute.ICopyableChannel;
import net.dv8tion.jda.api.entities.channel.attribute.IMemberContainer;
import net.dv8tion.jda.api.entities.channel.attribute.IPermissionContainer;
import net.dv8tion.jda.api.entities.channel.attribute.IPositionableChannel;
import net.dv8tion.jda.api.entities.channel.concrete.ForumChannel;
import net.dv8tion.jda.api.entities.channel.concrete.NewsChannel;
import net.dv8tion.jda.api.entities.channel.concrete.StageChannel;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.channel.concrete.VoiceChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.managers.channel.concrete.CategoryManager;
import net.dv8tion.jda.api.requests.restaction.ChannelAction;
import net.dv8tion.jda.api.requests.restaction.order.CategoryOrderAction;

public interface Category
extends GuildChannel,
ICopyableChannel,
IPositionableChannel,
IPermissionContainer,
IMemberContainer {
    @Nonnull
    default public List<GuildChannel> getChannels() {
        ArrayList<IAgeRestrictedChannel> channels = new ArrayList<IAgeRestrictedChannel>();
        channels.addAll(this.getTextChannels());
        channels.addAll(this.getVoiceChannels());
        channels.addAll(this.getStageChannels());
        channels.addAll(this.getNewsChannels());
        channels.addAll(this.getForumChannels());
        Collections.sort(channels);
        return Collections.unmodifiableList(channels);
    }

    @Nonnull
    default public List<TextChannel> getTextChannels() {
        return Collections.unmodifiableList(this.getGuild().getTextChannelCache().applyStream(stream -> stream.filter(channel -> this.equals(channel.getParentCategory())).sorted().collect(Collectors.toList())));
    }

    @Nonnull
    default public List<NewsChannel> getNewsChannels() {
        return Collections.unmodifiableList(this.getGuild().getNewsChannelCache().applyStream(stream -> stream.filter(channel -> this.equals(channel.getParentCategory())).sorted().collect(Collectors.toList())));
    }

    @Nonnull
    default public List<ForumChannel> getForumChannels() {
        return Collections.unmodifiableList(this.getGuild().getForumChannelCache().applyStream(stream -> stream.filter(channel -> this.equals(channel.getParentCategory())).sorted().collect(Collectors.toList())));
    }

    @Nonnull
    default public List<VoiceChannel> getVoiceChannels() {
        return Collections.unmodifiableList(this.getGuild().getVoiceChannelCache().applyStream(stream -> stream.filter(channel -> this.equals(channel.getParentCategory())).sorted().collect(Collectors.toList())));
    }

    @Nonnull
    default public List<StageChannel> getStageChannels() {
        return Collections.unmodifiableList(this.getGuild().getStageChannelCache().applyStream(stream -> stream.filter(channel -> this.equals(channel.getParentCategory())).sorted().collect(Collectors.toList())));
    }

    @Nonnull
    @CheckReturnValue
    public ChannelAction<TextChannel> createTextChannel(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    public ChannelAction<NewsChannel> createNewsChannel(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    public ChannelAction<VoiceChannel> createVoiceChannel(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    public ChannelAction<StageChannel> createStageChannel(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    public ChannelAction<ForumChannel> createForumChannel(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    public CategoryOrderAction modifyTextChannelPositions();

    @Nonnull
    @CheckReturnValue
    public CategoryOrderAction modifyVoiceChannelPositions();

    @Override
    @Nonnull
    default public List<Member> getMembers() {
        return Collections.unmodifiableList(this.getChannels().stream().filter(IMemberContainer.class::isInstance).map(IMemberContainer.class::cast).map(IMemberContainer::getMembers).flatMap(Collection::stream).distinct().collect(Collectors.toList()));
    }

    @Nonnull
    public ChannelAction<Category> createCopy(@Nonnull Guild var1);

    @Nonnull
    public ChannelAction<Category> createCopy();

    @Override
    @Nonnull
    public CategoryManager getManager();
}

