/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.requests.restaction;

import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.requests.Request;
import net.dv8tion.jda.api.requests.Response;
import net.dv8tion.jda.api.requests.Route;
import net.dv8tion.jda.api.requests.restaction.MessageEditAction;
import net.dv8tion.jda.api.utils.messages.MessageEditBuilder;
import net.dv8tion.jda.api.utils.messages.MessageEditData;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.utils.message.MessageEditBuilderMixin;
import okhttp3.RequestBody;

public class MessageEditActionImpl
extends RestActionImpl<Message>
implements MessageEditAction,
MessageEditBuilderMixin<MessageEditAction> {
    private final MessageChannel channel;
    private final MessageEditBuilder builder = new MessageEditBuilder();

    public MessageEditActionImpl(MessageChannel channel, String messageId) {
        super(channel.getJDA(), Route.Messages.EDIT_MESSAGE.compile(channel.getId(), messageId));
        this.channel = channel;
    }

    @Override
    public MessageEditBuilder getBuilder() {
        return this.builder;
    }

    @Override
    protected RequestBody finalizeData() {
        try (MessageEditData data = this.builder.build();){
            RequestBody requestBody = this.getMultipartBody(data.getFiles(), data.toData());
            return requestBody;
        }
    }

    @Override
    protected void handleSuccess(Response response, Request<Message> request) {
        request.onSuccess(this.api.getEntityBuilder().createMessageWithChannel(response.getObject(), this.channel, false));
    }

    @Override
    @Nonnull
    public MessageEditAction setCheck(BooleanSupplier checks) {
        return (MessageEditAction)super.setCheck(checks);
    }

    @Override
    @Nonnull
    public MessageEditAction deadline(long timestamp) {
        return (MessageEditAction)super.deadline(timestamp);
    }
}

