/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.components.textdisplay;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.components.Component;
import net.dv8tion.jda.api.components.MessageTopLevelComponent;
import net.dv8tion.jda.api.components.container.ContainerChildComponent;
import net.dv8tion.jda.api.components.section.SectionContentComponent;
import net.dv8tion.jda.internal.components.textdisplay.TextDisplayImpl;
import net.dv8tion.jda.internal.utils.Checks;

public interface TextDisplay
extends Component,
MessageTopLevelComponent,
ContainerChildComponent,
SectionContentComponent {
    @Nonnull
    public static TextDisplay of(@Nonnull String content) {
        Checks.notBlank(content, "Content");
        return new TextDisplayImpl(content);
    }

    @Nonnull
    public static TextDisplay ofFormat(@Nonnull String format, Object ... args) {
        Checks.notNull(format, "Format string");
        Checks.notNull(args, "Format args");
        return TextDisplay.of(String.format(format, args));
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public TextDisplay withUniqueId(int var1);

    @Nonnull
    @CheckReturnValue
    public TextDisplay withContent(@Nonnull String var1);

    @Nonnull
    public String getContent();
}

