/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.components;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.dv8tion.jda.annotations.ForRemoval;
import net.dv8tion.jda.annotations.ReplaceWith;
import net.dv8tion.jda.api.components.actionrow.ActionRow;

public interface Component {
    @Nonnull
    public Type getType();

    public int getUniqueId();

    @Nonnull
    @CheckReturnValue
    public Component withUniqueId(int var1);

    default public boolean isMessageCompatible() {
        return this.getType().isMessageCompatible();
    }

    default public boolean isModalCompatible() {
        return this.getType().isModalCompatible();
    }

    public static enum Type {
        UNKNOWN(-1, false, false),
        ACTION_ROW(1, true, true),
        BUTTON(2, true, false),
        STRING_SELECT(3, true, false),
        TEXT_INPUT(4, false, true),
        USER_SELECT(5, true, false),
        ROLE_SELECT(6, true, false),
        MENTIONABLE_SELECT(7, true, false),
        CHANNEL_SELECT(8, true, false),
        SECTION(9, true, false),
        TEXT_DISPLAY(10, true, false),
        THUMBNAIL(11, true, false),
        MEDIA_GALLERY(12, true, false),
        FILE_DISPLAY(13, true, false),
        SEPARATOR(14, true, false),
        CONTAINER(17, true, false);

        private final int key;
        private final boolean messageCompatible;
        private final boolean modalCompatible;

        private Type(int key, boolean messageCompatible, boolean modalCompatible) {
            this.key = key;
            this.messageCompatible = messageCompatible;
            this.modalCompatible = modalCompatible;
        }

        @Deprecated
        @ForRemoval
        @ReplaceWith(value="ActionRow.getMaxAllowed(Component.Type)")
        public int getMaxPerRow() {
            return ActionRow.getMaxAllowed(this);
        }

        public int getKey() {
            return this.key;
        }

        public boolean isMessageCompatible() {
            return this.messageCompatible;
        }

        public boolean isModalCompatible() {
            return this.modalCompatible;
        }

        @Nonnull
        public static Type fromKey(int type) {
            for (Type t : Type.values()) {
                if (t.key != type) continue;
                return t;
            }
            return UNKNOWN;
        }
    }
}

