/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.components.actionrow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.components.Component;
import net.dv8tion.jda.api.components.Components;
import net.dv8tion.jda.api.components.MessageTopLevelComponentUnion;
import net.dv8tion.jda.api.components.actionrow.ActionRow;
import net.dv8tion.jda.api.components.actionrow.ActionRowChildComponent;
import net.dv8tion.jda.api.components.actionrow.ActionRowChildComponentUnion;
import net.dv8tion.jda.api.components.container.ContainerChildComponentUnion;
import net.dv8tion.jda.api.components.replacer.ComponentReplacer;
import net.dv8tion.jda.api.interactions.modals.ModalTopLevelComponentUnion;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.components.AbstractComponentImpl;
import net.dv8tion.jda.internal.components.utils.ComponentsUtil;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.EntityString;
import net.dv8tion.jda.internal.utils.Helpers;

public class ActionRowImpl
extends AbstractComponentImpl
implements ActionRow,
MessageTopLevelComponentUnion,
ModalTopLevelComponentUnion,
ContainerChildComponentUnion {
    private final int uniqueId;
    private final List<ActionRowChildComponentUnion> components;

    public ActionRowImpl(DataObject data) {
        this(Components.parseComponents(ActionRowChildComponentUnion.class, data.getArray("components")), data.getInt("id", -1));
    }

    private ActionRowImpl(Collection<ActionRowChildComponentUnion> components) {
        this(components, -1);
    }

    public ActionRowImpl(Collection<ActionRowChildComponentUnion> components, int uniqueId) {
        Checks.notEmpty(components, "Row");
        ActionRowImpl.checkIsValid(components);
        this.uniqueId = uniqueId;
        this.components = Helpers.copyAsUnmodifiableList(components);
    }

    @Nonnull
    public static ActionRow of(@Nonnull Collection<? extends ActionRowChildComponent> components) {
        Checks.noneNull(components, "Components");
        List<ActionRowChildComponentUnion> componentUnions = ComponentsUtil.membersToUnion(components, ActionRowChildComponentUnion.class);
        return new ActionRowImpl(componentUnions);
    }

    @Nonnull
    public static List<ActionRow> partitionOf(@Nonnull Collection<? extends ActionRowChildComponent> components) {
        Checks.noneNull(components, "Components");
        Checks.notEmpty(components, "Components");
        List<ActionRowChildComponentUnion> componentUnions = ComponentsUtil.membersToUnion(components, ActionRowChildComponentUnion.class);
        ArrayList<ActionRow> rows = new ArrayList<ActionRow>();
        ArrayList<ActionRowChildComponentUnion> currentRow = new ArrayList<ActionRowChildComponentUnion>();
        Component.Type type = null;
        for (ActionRowChildComponentUnion current : componentUnions) {
            if (type != null && type != current.getType() || currentRow.size() == ActionRow.getMaxAllowed(current.getType())) {
                rows.add(ActionRow.of(currentRow));
                currentRow.clear();
            }
            type = current.getType();
            currentRow.add(current);
        }
        rows.add(ActionRow.of(currentRow));
        return rows;
    }

    @Override
    public int getUniqueId() {
        return this.uniqueId;
    }

    @Override
    @Nonnull
    public List<ActionRowChildComponentUnion> getComponents() {
        return this.components;
    }

    @Override
    @Nonnull
    public ActionRow replace(@Nonnull ComponentReplacer replacer) {
        Checks.notNull(replacer, "ComponentReplacer");
        return ComponentsUtil.doReplace(ActionRowChildComponent.class, this.components, replacer, newComponents -> new ActionRowImpl((Collection<ActionRowChildComponentUnion>)newComponents, this.uniqueId));
    }

    @Override
    @Nonnull
    public ActionRowImpl withUniqueId(int uniqueId) {
        Checks.positive(uniqueId, "Unique ID");
        return new ActionRowImpl(this.components, uniqueId);
    }

    @Override
    @Nonnull
    public Component.Type getType() {
        return Component.Type.ACTION_ROW;
    }

    @Override
    @Nonnull
    public DataObject toData() {
        DataObject json = DataObject.empty().put("type", 1).put("components", DataArray.fromCollection(this.components));
        if (this.uniqueId >= 0) {
            json.put("id", this.uniqueId);
        }
        return json;
    }

    private static void checkIsValid(Collection<ActionRowChildComponentUnion> components) {
        Map<Component.Type, List<ActionRowChildComponentUnion>> groups = components.stream().collect(Collectors.groupingBy(Component::getType));
        if (groups.size() > 1) {
            throw new IllegalArgumentException("Cannot create action row containing different component types! Provided: " + groups.keySet());
        }
        for (Map.Entry<Component.Type, List<ActionRowChildComponentUnion>> entry : groups.entrySet()) {
            Component.Type type = entry.getKey();
            List<ActionRowChildComponentUnion> list = entry.getValue();
            int maxAllowed = ActionRow.getMaxAllowed(type);
            Checks.check(list.size() <= maxAllowed, "Cannot create an action row with more than %d %s! Provided: %d", maxAllowed, type.name(), list.size());
        }
    }

    public String toString() {
        return new EntityString(this).addMetadata("id", this.uniqueId).addMetadata("components", this.components).toString();
    }

    public int hashCode() {
        return this.components.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ActionRowImpl)) {
            return false;
        }
        return this.components.equals(((ActionRowImpl)obj).components);
    }
}

