/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.components;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.components.Component;
import net.dv8tion.jda.api.components.IComponentUnion;
import net.dv8tion.jda.api.components.MessageTopLevelComponentUnion;
import net.dv8tion.jda.api.components.ModalTopLevelComponentUnion;
import net.dv8tion.jda.api.components.tree.ComponentTree;
import net.dv8tion.jda.api.components.tree.MessageComponentTree;
import net.dv8tion.jda.api.components.tree.ModalComponentTree;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.components.UnknownComponentImpl;
import net.dv8tion.jda.internal.components.actionrow.ActionRowImpl;
import net.dv8tion.jda.internal.components.buttons.ButtonImpl;
import net.dv8tion.jda.internal.components.container.ContainerImpl;
import net.dv8tion.jda.internal.components.filedisplay.FileDisplayImpl;
import net.dv8tion.jda.internal.components.label.LabelImpl;
import net.dv8tion.jda.internal.components.mediagallery.MediaGalleryImpl;
import net.dv8tion.jda.internal.components.section.SectionImpl;
import net.dv8tion.jda.internal.components.selections.EntitySelectMenuImpl;
import net.dv8tion.jda.internal.components.selections.StringSelectMenuImpl;
import net.dv8tion.jda.internal.components.separator.SeparatorImpl;
import net.dv8tion.jda.internal.components.textdisplay.TextDisplayImpl;
import net.dv8tion.jda.internal.components.textinput.TextInputImpl;
import net.dv8tion.jda.internal.components.thumbnail.ThumbnailImpl;
import net.dv8tion.jda.internal.components.utils.ComponentsUtil;
import net.dv8tion.jda.internal.utils.Checks;

public class Components {
    @Nonnull
    public static <T extends Component> T parseComponent(@Nonnull Class<T> componentType, @Nonnull DataObject data) {
        Checks.notNull(componentType, "Component type");
        Checks.notNull(data, "Data");
        IComponentUnion component = Components.parseComponent(data);
        return ComponentsUtil.safeUnionCastWithUnknownType("component", component, componentType);
    }

    @Nonnull
    private static IComponentUnion parseComponent(@Nonnull DataObject data) {
        switch (Component.Type.fromKey(data.getInt("type"))) {
            case ACTION_ROW: {
                return new ActionRowImpl(data);
            }
            case BUTTON: {
                return new ButtonImpl(data);
            }
            case STRING_SELECT: {
                return new StringSelectMenuImpl(data);
            }
            case TEXT_INPUT: {
                return new TextInputImpl(data);
            }
            case USER_SELECT: 
            case ROLE_SELECT: 
            case MENTIONABLE_SELECT: 
            case CHANNEL_SELECT: {
                return new EntitySelectMenuImpl(data);
            }
            case SECTION: {
                return new SectionImpl(data);
            }
            case TEXT_DISPLAY: {
                return new TextDisplayImpl(data);
            }
            case THUMBNAIL: {
                return new ThumbnailImpl(data);
            }
            case MEDIA_GALLERY: {
                return new MediaGalleryImpl(data);
            }
            case FILE_DISPLAY: {
                return new FileDisplayImpl(data);
            }
            case SEPARATOR: {
                return new SeparatorImpl(data);
            }
            case CONTAINER: {
                return new ContainerImpl(data);
            }
            case LABEL: {
                return new LabelImpl(data);
            }
        }
        return new UnknownComponentImpl(data);
    }

    @Nonnull
    public static <T extends Component> List<T> parseComponents(@Nonnull Class<T> componentType, @Nonnull DataArray data) {
        Checks.notNull(componentType, "Component type");
        Checks.notNull(data, "Data");
        return (List)Components.parseTo(componentType, data, Function.identity());
    }

    @Nonnull
    public static <T extends ComponentTree<?>> T parseTree(@Nonnull Class<T> treeType, @Nonnull DataArray data) {
        Checks.notNull(treeType, "Tree type");
        Checks.notNull(data, "Data");
        if (MessageComponentTree.class.isAssignableFrom(treeType)) {
            return (T)Components.parseTo(MessageTopLevelComponentUnion.class, data, MessageComponentTree::of);
        }
        if (ModalComponentTree.class.isAssignableFrom(treeType)) {
            return (T)Components.parseTo(ModalTopLevelComponentUnion.class, data, ModalComponentTree::of);
        }
        if (ComponentTree.class.isAssignableFrom(treeType)) {
            return (T)Components.parseTo(IComponentUnion.class, data, ComponentTree::of);
        }
        throw new UnsupportedOperationException("Cannot deserialize to tree of type " + treeType.getName());
    }

    @Nonnull
    private static <R, U extends Component> R parseTo(@Nonnull Class<U> topLevelComponentType, @Nonnull DataArray data, @Nonnull Function<List<U>, R> treeFactory) {
        List components = data.stream(DataArray::getObject).map(obj -> Components.parseComponent(topLevelComponentType, obj)).collect(Collectors.toList());
        return treeFactory.apply(components);
    }
}

