/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formattable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.annotations.ForRemoval;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.components.MessageTopLevelComponent;
import net.dv8tion.jda.api.components.MessageTopLevelComponentUnion;
import net.dv8tion.jda.api.components.actionrow.ActionRow;
import net.dv8tion.jda.api.components.buttons.Button;
import net.dv8tion.jda.api.components.tree.ComponentTree;
import net.dv8tion.jda.api.components.tree.MessageComponentTree;
import net.dv8tion.jda.api.components.utils.ComponentIterator;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Mentions;
import net.dv8tion.jda.api.entities.MessageActivity;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.MessageReaction;
import net.dv8tion.jda.api.entities.MessageReference;
import net.dv8tion.jda.api.entities.MessageType;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.concrete.Category;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.entities.channel.unions.GuildMessageChannelUnion;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.entities.messages.MessagePoll;
import net.dv8tion.jda.api.entities.messages.MessageSnapshot;
import net.dv8tion.jda.api.entities.sticker.StickerItem;
import net.dv8tion.jda.api.entities.sticker.StickerSnowflake;
import net.dv8tion.jda.api.interactions.IntegrationOwners;
import net.dv8tion.jda.api.interactions.InteractionType;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.dv8tion.jda.api.requests.restaction.MessageEditAction;
import net.dv8tion.jda.api.requests.restaction.ThreadChannelAction;
import net.dv8tion.jda.api.requests.restaction.pagination.PollVotersPaginationAction;
import net.dv8tion.jda.api.requests.restaction.pagination.ReactionPaginationAction;
import net.dv8tion.jda.api.utils.AttachedFile;
import net.dv8tion.jda.api.utils.FileUpload;
import net.dv8tion.jda.api.utils.NamedAttachmentProxy;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.api.utils.messages.MessageCreateData;
import net.dv8tion.jda.api.utils.messages.MessageEditData;
import net.dv8tion.jda.api.utils.messages.MessagePollData;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.ReceivedMessage;
import net.dv8tion.jda.internal.entities.channel.mixin.middleman.MessageChannelMixin;
import net.dv8tion.jda.internal.requests.restaction.MessageCreateActionImpl;
import net.dv8tion.jda.internal.requests.restaction.pagination.PollVotersPaginationActionImpl;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.Helpers;
import okhttp3.MultipartBody;
import org.jetbrains.annotations.Unmodifiable;

public interface Message
extends ISnowflake,
Formattable {
    public static final String JUMP_URL = "https://discord.com/channels/%s/%s/%s";
    public static final int MAX_FILE_SIZE = 0xA00000;
    public static final int MAX_FILE_AMOUNT = 10;
    public static final int MAX_CONTENT_LENGTH = 2000;
    public static final int MAX_CONTENT_LENGTH_COMPONENT_V2 = 4000;
    public static final int MAX_REACTIONS = 20;
    public static final int MAX_EMBED_COUNT = 10;
    public static final int MAX_STICKER_COUNT = 3;
    public static final int MAX_COMPONENT_COUNT = 5;
    public static final int MAX_COMPONENT_COUNT_IN_COMPONENT_TREE = 40;
    public static final int MAX_NONCE_LENGTH = 25;
    public static final Pattern INVITE_PATTERN = Pattern.compile("(?:https?://)?(?:\\w+\\.)?discord(?:(?:app)?\\.com/invite[/\\\\]|\\.gg/)(?<code>[a-z0-9-]+)(?:\\?\\S*)?(?:#\\S*)?", 2);
    public static final Pattern JUMP_URL_PATTERN = Pattern.compile("(?:https?://)?(?:\\w+\\.)?discord(?:app)?\\.com/channels/(?<guild>\\d+)/(?<channel>\\d+)/(?<message>\\d+)(?:\\?\\S*)?(?:#\\S*)?", 2);

    public static void suppressContentIntentWarning() {
        ReceivedMessage.didContentIntentWarning = true;
    }

    @Nullable
    public MessageReference getMessageReference();

    @Nullable
    default public Message getReferencedMessage() {
        return this.getMessageReference() != null ? this.getMessageReference().getMessage() : null;
    }

    @Nonnull
    public Mentions getMentions();

    public boolean isEdited();

    @Nullable
    public OffsetDateTime getTimeEdited();

    @Nonnull
    public User getAuthor();

    @Nullable
    public Member getMember();

    public int getApproximatePosition();

    @Nonnull
    public String getJumpUrl();

    @Nonnull
    public String getContentDisplay();

    @Nonnull
    public String getContentRaw();

    @Nonnull
    public String getContentStripped();

    @Nonnull
    public @Unmodifiable List<String> getInvites();

    @Nullable
    public String getNonce();

    public boolean isFromType(@Nonnull ChannelType var1);

    public boolean isFromGuild();

    @Nonnull
    public ChannelType getChannelType();

    public boolean isWebhookMessage();

    @Nullable
    default public String getApplicationId() {
        return this.getApplicationIdLong() == 0L ? null : Long.toUnsignedString(this.getApplicationIdLong());
    }

    public long getApplicationIdLong();

    public boolean hasChannel();

    public long getChannelIdLong();

    @Nonnull
    default public String getChannelId() {
        return Long.toUnsignedString(this.getChannelIdLong());
    }

    @Nonnull
    public MessageChannelUnion getChannel();

    @Nonnull
    public GuildMessageChannelUnion getGuildChannel();

    @Nullable
    public Category getCategory();

    public boolean hasGuild();

    public long getGuildIdLong();

    @Nullable
    default public String getGuildId() {
        return this.isFromGuild() ? Long.toUnsignedString(this.getGuildIdLong()) : null;
    }

    @Nonnull
    public Guild getGuild();

    @Nonnull
    public @Unmodifiable List<Attachment> getAttachments();

    @Nonnull
    public @Unmodifiable List<MessageEmbed> getEmbeds();

    @Nonnull
    public @Unmodifiable List<MessageTopLevelComponentUnion> getComponents();

    public boolean isUsingComponentsV2();

    @Nonnull
    default public MessageComponentTree getComponentTree() {
        return MessageComponentTree.of(this.getComponents());
    }

    @Nullable
    public MessagePoll getPoll();

    @Nonnull
    @CheckReturnValue
    public AuditableRestAction<Message> endPoll();

    @Nonnull
    @CheckReturnValue
    default public PollVotersPaginationAction retrievePollVoters(long answerId) {
        return new PollVotersPaginationActionImpl(this.getJDA(), this.getChannelId(), this.getId(), answerId);
    }

    @Nonnull
    @Deprecated
    @ForRemoval
    default public @Unmodifiable List<ActionRow> getActionRows() {
        return ComponentIterator.createStream(this.getComponents()).filter(ActionRow.class::isInstance).map(ActionRow.class::cast).collect(Helpers.toUnmodifiableList());
    }

    @Nonnull
    @Deprecated
    @ForRemoval
    default public @Unmodifiable List<Button> getButtons() {
        return ComponentIterator.createStream(this.getComponents()).filter(Button.class::isInstance).map(Button.class::cast).collect(Collectors.toList());
    }

    @Nullable
    @Deprecated
    @ForRemoval
    default public Button getButtonById(@Nonnull String id) {
        Checks.notNull(id, "Button ID");
        return this.getButtons().stream().filter(it -> id.equals(it.getCustomId())).findFirst().orElse(null);
    }

    @Nonnull
    @Deprecated
    @ForRemoval
    default public @Unmodifiable List<Button> getButtonsByLabel(@Nonnull String label, boolean ignoreCase) {
        Checks.notNull(label, "Label");
        Predicate<Button> filter = ignoreCase ? b -> label.equalsIgnoreCase(b.getLabel()) : b -> label.equals(b.getLabel());
        return this.getButtons().stream().filter(filter).collect(Helpers.toUnmodifiableList());
    }

    @Nonnull
    public @Unmodifiable List<MessageReaction> getReactions();

    @Nonnull
    public @Unmodifiable List<StickerItem> getStickers();

    @Nonnull
    public @Unmodifiable List<MessageSnapshot> getMessageSnapshots();

    public boolean isTTS();

    @Nullable
    public MessageActivity getActivity();

    @Nonnull
    @CheckReturnValue
    public MessageEditAction editMessage(@Nonnull CharSequence var1);

    @Nonnull
    @CheckReturnValue
    public MessageEditAction editMessage(@Nonnull MessageEditData var1);

    @Nonnull
    @CheckReturnValue
    public MessageEditAction editMessageEmbeds(@Nonnull Collection<? extends MessageEmbed> var1);

    @Nonnull
    @CheckReturnValue
    default public MessageEditAction editMessageEmbeds(MessageEmbed ... embeds) {
        Checks.noneNull(embeds, "MessageEmbeds");
        return this.editMessageEmbeds(Arrays.asList(embeds));
    }

    @Nonnull
    @CheckReturnValue
    public MessageEditAction editMessageComponents(@Nonnull Collection<? extends MessageTopLevelComponent> var1);

    @Nonnull
    @CheckReturnValue
    default public MessageEditAction editMessageComponents(MessageTopLevelComponent ... components) {
        Checks.noneNull(components, "Components");
        return this.editMessageComponents(Arrays.asList(components));
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditAction editMessageComponents(@Nonnull ComponentTree<? extends MessageTopLevelComponent> tree) {
        Checks.notNull(tree, "ComponentTree");
        return this.editMessageComponents(tree.getComponents());
    }

    @Nonnull
    @CheckReturnValue
    public MessageEditAction editMessageFormat(@Nonnull String var1, Object ... var2);

    @Nonnull
    @CheckReturnValue
    public MessageEditAction editMessageAttachments(@Nonnull Collection<? extends AttachedFile> var1);

    @Nonnull
    @CheckReturnValue
    default public MessageEditAction editMessageAttachments(AttachedFile ... attachments) {
        Checks.noneNull(attachments, "Attachments");
        return this.editMessageAttachments(Arrays.asList(attachments));
    }

    @Nonnull
    @CheckReturnValue
    default public MessageCreateAction replyStickers(@Nonnull Collection<? extends StickerSnowflake> stickers) {
        return this.getGuildChannel().sendStickers(stickers).setMessageReference(this);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageCreateAction replyStickers(StickerSnowflake ... stickers) {
        return this.getGuildChannel().sendStickers(stickers).setMessageReference(this);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageCreateAction reply(@Nonnull CharSequence content) {
        return this.getChannel().sendMessage(content).setMessageReference(this);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageCreateAction reply(@Nonnull MessageCreateData msg) {
        return this.getChannel().sendMessage(msg).setMessageReference(this);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageCreateAction replyPoll(@Nonnull MessagePollData poll) {
        return this.getChannel().sendMessagePoll(poll).setMessageReference(this);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageCreateAction replyEmbeds(@Nonnull MessageEmbed embed, MessageEmbed ... other) {
        Checks.notNull(embed, "MessageEmbeds");
        Checks.noneNull(other, "MessageEmbeds");
        ArrayList<MessageEmbed> embeds = new ArrayList<MessageEmbed>(1 + other.length);
        embeds.add(embed);
        Collections.addAll(embeds, other);
        return this.replyEmbeds(embeds);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageCreateAction replyEmbeds(@Nonnull Collection<? extends MessageEmbed> embeds) {
        return this.getChannel().sendMessageEmbeds(embeds).setMessageReference(this);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageCreateAction replyComponents(@Nonnull Collection<? extends MessageTopLevelComponent> components) {
        Checks.noneNull(components, "MessageTopLevelComponents");
        return this.getChannel().sendMessageComponents(components).setMessageReference(this);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageCreateAction replyComponents(@Nonnull MessageTopLevelComponent component, MessageTopLevelComponent ... other) {
        Checks.notNull(component, "MessageTopLevelComponents");
        Checks.noneNull(other, "MessageTopLevelComponents");
        ArrayList<MessageTopLevelComponent> components = new ArrayList<MessageTopLevelComponent>(1 + other.length);
        components.add(component);
        Collections.addAll(components, other);
        return this.replyComponents(components);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageCreateAction replyComponents(@Nonnull ComponentTree<? extends MessageTopLevelComponent> tree) {
        Checks.notNull(tree, "ComponentTree");
        return this.replyComponents(tree.getComponents());
    }

    @Nonnull
    @CheckReturnValue
    default public MessageCreateAction replyFormat(@Nonnull String format, Object ... args) {
        return this.getChannel().sendMessageFormat(format, args).setMessageReference(this);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageCreateAction replyFiles(FileUpload ... files) {
        return this.getChannel().sendFiles(files).setMessageReference(this);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageCreateAction replyFiles(@Nonnull Collection<? extends FileUpload> files) {
        return this.getChannel().sendFiles(files).setMessageReference(this);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageCreateAction forwardTo(@Nonnull MessageChannel channel) {
        Checks.notNull(channel, "Target channel");
        if (channel instanceof MessageChannelMixin) {
            ((MessageChannelMixin)channel).checkCanSendMessage();
        }
        return new MessageCreateActionImpl(channel).setMessageReference(MessageReference.MessageReferenceType.FORWARD, this);
    }

    @Nonnull
    @CheckReturnValue
    public AuditableRestAction<Void> delete();

    @Nonnull
    public JDA getJDA();

    public boolean isPinned();

    @Nonnull
    @CheckReturnValue
    public AuditableRestAction<Void> pin();

    @Nonnull
    @CheckReturnValue
    public AuditableRestAction<Void> unpin();

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> addReaction(@Nonnull Emoji var1);

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> clearReactions();

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> clearReactions(@Nonnull Emoji var1);

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> removeReaction(@Nonnull Emoji var1);

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> removeReaction(@Nonnull Emoji var1, @Nonnull User var2);

    @Nonnull
    @CheckReturnValue
    default public ReactionPaginationAction retrieveReactionUsers(@Nonnull Emoji emoji) {
        return this.retrieveReactionUsers(emoji, MessageReaction.ReactionType.NORMAL);
    }

    @Nonnull
    @CheckReturnValue
    public ReactionPaginationAction retrieveReactionUsers(@Nonnull Emoji var1, @Nonnull MessageReaction.ReactionType var2);

    @Nullable
    @CheckReturnValue
    public MessageReaction getReaction(@Nonnull Emoji var1);

    @Nonnull
    @CheckReturnValue
    public AuditableRestAction<Void> suppressEmbeds(boolean var1);

    @Nonnull
    @CheckReturnValue
    public RestAction<Message> crosspost();

    public boolean isSuppressedEmbeds();

    @Nonnull
    public EnumSet<MessageFlag> getFlags();

    public long getFlagsRaw();

    public boolean isEphemeral();

    public boolean isSuppressedNotifications();

    public boolean isVoiceMessage();

    @Nullable
    public ThreadChannel getStartedThread();

    @Nonnull
    public MessageType getType();

    @Nullable
    @Deprecated
    public Interaction getInteraction();

    @Nullable
    public InteractionMetadata getInteractionMetadata();

    @Nonnull
    @CheckReturnValue
    public ThreadChannelAction createThreadChannel(@Nonnull String var1);

    public static class InteractionMetadata
    implements ISnowflake {
        private final long id;
        private final int type;
        private final User user;
        private final IntegrationOwners integrationOwners;
        private final long originalResponseMessageId;
        private final long interactedMessageId;
        private final InteractionMetadata triggeringInteraction;
        private final User targetUser;
        private final long targetMessageId;

        public InteractionMetadata(long id, int type, User user, IntegrationOwners integrationOwners, long originalResponseMessageId, long interactedMessageId, InteractionMetadata triggeringInteraction, User targetUser, long targetMessageId) {
            this.id = id;
            this.type = type;
            this.user = user;
            this.integrationOwners = integrationOwners;
            this.originalResponseMessageId = originalResponseMessageId;
            this.interactedMessageId = interactedMessageId;
            this.triggeringInteraction = triggeringInteraction;
            this.targetUser = targetUser;
            this.targetMessageId = targetMessageId;
        }

        @Override
        public long getIdLong() {
            return this.id;
        }

        public int getTypeRaw() {
            return this.type;
        }

        @Nonnull
        public InteractionType getType() {
            return InteractionType.fromKey(this.type);
        }

        @Nonnull
        public User getUser() {
            return this.user;
        }

        @Nonnull
        public IntegrationOwners getIntegrationOwners() {
            return this.integrationOwners;
        }

        public long getOriginalResponseMessageIdLong() {
            return this.originalResponseMessageId;
        }

        @Nullable
        public String getOriginalResponseMessageId() {
            if (this.originalResponseMessageId == 0L) {
                return null;
            }
            return Long.toUnsignedString(this.originalResponseMessageId);
        }

        public long getInteractedMessageIdLong() {
            return this.interactedMessageId;
        }

        @Nullable
        public String getInteractedMessageId() {
            if (this.interactedMessageId == 0L) {
                return null;
            }
            return Long.toUnsignedString(this.interactedMessageId);
        }

        @Nullable
        public InteractionMetadata getTriggeringInteraction() {
            return this.triggeringInteraction;
        }

        @Nullable
        public User getTargetUser() {
            return this.targetUser;
        }

        public long getTargetMessageIdLong() {
            return this.targetMessageId;
        }

        @Nullable
        public String getTargetMessageId() {
            if (this.targetMessageId == 0L) {
                return null;
            }
            return Long.toUnsignedString(this.targetMessageId);
        }
    }

    @Deprecated
    public static class Interaction
    implements ISnowflake {
        private final long id;
        private final int type;
        private final String name;
        private final User user;
        private final Member member;

        public Interaction(long id, int type, String name, User user, Member member) {
            this.id = id;
            this.type = type;
            this.name = name;
            this.user = user;
            this.member = member;
        }

        @Override
        public long getIdLong() {
            return this.id;
        }

        public int getTypeRaw() {
            return this.type;
        }

        @Nonnull
        public InteractionType getType() {
            return InteractionType.fromKey(this.getTypeRaw());
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nonnull
        public User getUser() {
            return this.user;
        }

        @Nullable
        public Member getMember() {
            return this.member;
        }
    }

    public static class Attachment
    implements ISnowflake,
    AttachedFile {
        private static final Set<String> IMAGE_EXTENSIONS = new HashSet<String>(Arrays.asList("jpg", "jpeg", "png", "gif", "webp", "tiff", "svg", "apng"));
        private static final Set<String> VIDEO_EXTENSIONS = new HashSet<String>(Arrays.asList("webm", "flv", "vob", "avi", "mov", "wmv", "amv", "mp4", "mpg", "mpeg", "gifv"));
        private final long id;
        private final String url;
        private final String proxyUrl;
        private final String fileName;
        private final String contentType;
        private final String description;
        private final int size;
        private final int height;
        private final int width;
        private final boolean ephemeral;
        private final String waveform;
        private final double duration;
        private final JDAImpl jda;

        public Attachment(long id, String url, String proxyUrl, String fileName, String contentType, String description, int size, int height, int width, boolean ephemeral, String waveform, double duration, JDAImpl jda) {
            this.id = id;
            this.url = url;
            this.proxyUrl = proxyUrl;
            this.fileName = fileName;
            this.contentType = contentType;
            this.description = description;
            this.size = size;
            this.height = height;
            this.width = width;
            this.ephemeral = ephemeral;
            this.waveform = waveform;
            this.duration = duration;
            this.jda = jda;
        }

        @Nonnull
        public JDA getJDA() {
            return this.jda;
        }

        @Override
        public long getIdLong() {
            return this.id;
        }

        @Nonnull
        public String getUrl() {
            return this.url;
        }

        @Nonnull
        public String getProxyUrl() {
            return this.proxyUrl;
        }

        @Nonnull
        public NamedAttachmentProxy getProxy() {
            return new NamedAttachmentProxy(this.width > 0 && this.height > 0 ? this.proxyUrl : this.url, this.fileName);
        }

        @Nonnull
        public String getFileName() {
            return this.fileName;
        }

        @Nullable
        public String getFileExtension() {
            int index = this.fileName.lastIndexOf(46) + 1;
            return index == 0 || index == this.fileName.length() ? null : this.fileName.substring(index);
        }

        @Nullable
        public String getContentType() {
            return this.contentType;
        }

        @Nullable
        public String getDescription() {
            return this.description;
        }

        public int getSize() {
            return this.size;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isEphemeral() {
            return this.ephemeral;
        }

        @Nullable
        public byte[] getWaveform() {
            if (this.waveform == null) {
                return null;
            }
            return Base64.getDecoder().decode(this.waveform);
        }

        public double getDuration() {
            return this.duration;
        }

        public boolean isImage() {
            if (this.width < 0) {
                return false;
            }
            String extension = this.getFileExtension();
            return extension != null && IMAGE_EXTENSIONS.contains(extension.toLowerCase());
        }

        public boolean isVideo() {
            if (this.width < 0) {
                return false;
            }
            String extension = this.getFileExtension();
            return extension != null && VIDEO_EXTENSIONS.contains(extension.toLowerCase());
        }

        public boolean isSpoiler() {
            return this.getFileName().startsWith("SPOILER_");
        }

        @Override
        public void close() {
        }

        @Override
        public void forceClose() {
        }

        @Override
        public void addPart(@Nonnull MultipartBody.Builder builder, int index) {
        }

        @Override
        @Nonnull
        public DataObject toAttachmentData(int index) {
            return DataObject.empty().put("id", this.id);
        }
    }

    public static enum MessageFlag {
        CROSSPOSTED(0),
        IS_CROSSPOST(1),
        EMBEDS_SUPPRESSED(2),
        SOURCE_MESSAGE_DELETED(3),
        URGENT(4),
        EPHEMERAL(6),
        LOADING(7),
        NOTIFICATIONS_SUPPRESSED(12),
        IS_VOICE_MESSAGE(13),
        IS_COMPONENTS_V2(15);

        private final int value;

        private MessageFlag(int offset) {
            this.value = 1 << offset;
        }

        public int getValue() {
            return this.value;
        }

        @Nonnull
        public static EnumSet<MessageFlag> fromBitField(int bitfield) {
            Set set = Arrays.stream(MessageFlag.values()).filter(e -> (e.value & bitfield) > 0).collect(Collectors.toSet());
            return set.isEmpty() ? EnumSet.noneOf(MessageFlag.class) : EnumSet.copyOf(set);
        }

        public static int toBitField(@Nonnull Collection<MessageFlag> coll) {
            Checks.notNull(coll, "Collection");
            int flags = 0;
            for (MessageFlag messageFlag : coll) {
                flags |= messageFlag.value;
            }
            return flags;
        }
    }

    public static enum MentionType {
        USER("<@!?(\\d+)>", "users"),
        ROLE("<@&(\\d+)>", "roles"),
        CHANNEL("<#(\\d+)>", null),
        EMOJI("<a?:([a-zA-Z0-9_]+):([0-9]+)>", null),
        HERE("@here", "everyone"),
        EVERYONE("@everyone", "everyone"),
        SLASH_COMMAND("</([\\w-]+)(?> ([\\w-]+))??(?> ([\\w-]+))?:(\\d+)>", null);

        private final Pattern pattern;
        private final String parseKey;

        private MentionType(String regex, String parseKey) {
            this.pattern = Pattern.compile(regex);
            this.parseKey = parseKey;
        }

        @Nonnull
        public Pattern getPattern() {
            return this.pattern;
        }

        @Nullable
        public String getParseKey() {
            return this.parseKey;
        }
    }
}

