/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.interactions.modals;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.dv8tion.jda.annotations.ForRemoval;
import net.dv8tion.jda.annotations.ReplaceWith;
import net.dv8tion.jda.api.components.Component;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.utils.EntityString;
import net.dv8tion.jda.internal.utils.Helpers;

public class ModalMapping {
    private final String customId;
    private final int uniqueId;
    private final DataObject value;
    private final Component.Type type;

    public ModalMapping(DataObject object) {
        this.uniqueId = object.getInt("id");
        this.customId = object.getString("custom_id");
        this.type = Component.Type.fromKey(object.getInt("type"));
        this.value = object;
    }

    @Nonnull
    @Deprecated
    @ForRemoval
    @ReplaceWith(value="getCustomId()")
    public String getId() {
        return this.customId;
    }

    @Nonnull
    public String getCustomId() {
        return this.customId;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    @Nonnull
    public Component.Type getType() {
        return this.type;
    }

    @Nonnull
    public String getAsString() {
        if (this.type != Component.Type.TEXT_INPUT) {
            this.typeError("String");
        }
        return this.value.getString("value");
    }

    @Nonnull
    public List<String> getAsStringList() {
        if (this.type != Component.Type.STRING_SELECT) {
            this.typeError("List<String>");
        }
        return this.value.getArray("values").stream(DataArray::getString).collect(Helpers.toUnmodifiableList());
    }

    public String toString() {
        return new EntityString(this).setType(this.getType()).addMetadata("customId", this.customId).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModalMapping)) {
            return false;
        }
        ModalMapping that = (ModalMapping)o;
        return this.type == that.type && Objects.equals(this.customId, that.customId) && Objects.equals(this.uniqueId, that.uniqueId) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.customId, this.uniqueId, this.value, this.type});
    }

    private void typeError(String targetType) {
        throw new IllegalStateException("ModalMapping of type " + (Object)((Object)this.getType()) + " can not be represented as " + targetType + "!");
    }
}

