/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.components.label;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.components.Component;
import net.dv8tion.jda.api.components.Components;
import net.dv8tion.jda.api.components.ModalTopLevelComponentUnion;
import net.dv8tion.jda.api.components.label.Label;
import net.dv8tion.jda.api.components.label.LabelChildComponent;
import net.dv8tion.jda.api.components.label.LabelChildComponentUnion;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.components.AbstractComponentImpl;
import net.dv8tion.jda.internal.components.utils.ComponentsUtil;
import net.dv8tion.jda.internal.utils.Checks;

public class LabelImpl
extends AbstractComponentImpl
implements Label,
ModalTopLevelComponentUnion {
    private final int uniqueId;
    private final String label;
    private final String description;
    private final LabelChildComponentUnion child;

    public LabelImpl(@Nonnull DataObject object) {
        this(object.getInt("id"), object.getString("label"), object.getString("description", null), Components.parseComponent(LabelChildComponentUnion.class, object.getObject("child")));
    }

    public LabelImpl(@Nonnull String label, @Nullable String description, @Nonnull LabelChildComponentUnion child) {
        this(-1, label, description, child);
    }

    private LabelImpl(int uniqueId, @Nonnull String label, @Nullable String description, @Nonnull LabelChildComponentUnion child) {
        this.uniqueId = uniqueId;
        this.label = label;
        this.description = description;
        this.child = child;
    }

    public static Label of(@Nonnull String label, @Nullable String description, @Nonnull LabelChildComponent child) {
        Checks.notBlank(label, "Label");
        Checks.notLonger(label, 45, "Label");
        Checks.notNull(child, "Child");
        if (description != null) {
            Checks.notBlank(description, "Description");
            Checks.notLonger(description, 100, "Description");
        }
        LabelChildComponentUnion childUnion = ComponentsUtil.safeUnionCast("child", child, LabelChildComponentUnion.class);
        return new LabelImpl(label, description, childUnion);
    }

    @Override
    @Nonnull
    public Label withLabel(@Nonnull String label) {
        return LabelImpl.of(label, this.description, this.child);
    }

    @Override
    @Nonnull
    public Label withDescription(@Nullable String description) {
        return LabelImpl.of(this.label, description, this.child);
    }

    @Override
    @Nonnull
    public Label withChild(@Nonnull LabelChildComponent child) {
        return LabelImpl.of(this.label, this.description, child);
    }

    @Override
    @Nonnull
    public LabelImpl withUniqueId(int uniqueId) {
        return new LabelImpl(uniqueId, this.label, this.description, this.child);
    }

    @Override
    @Nonnull
    public Component.Type getType() {
        return Component.Type.LABEL;
    }

    @Override
    public int getUniqueId() {
        return this.uniqueId;
    }

    @Override
    @Nonnull
    public String getLabel() {
        return this.label;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nonnull
    public LabelChildComponentUnion getChild() {
        return this.child;
    }

    @Override
    @Nonnull
    public DataObject toData() {
        DataObject obj = DataObject.empty().put("type", this.getType().getKey()).put("label", this.label).put("description", this.description).put("component", this.child);
        if (this.uniqueId >= 0) {
            obj.put("id", this.uniqueId);
        }
        return obj;
    }
}

