/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.modals;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.components.Components;
import net.dv8tion.jda.api.components.ModalTopLevelComponentUnion;
import net.dv8tion.jda.api.modals.Modal;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.api.utils.data.SerializableData;
import net.dv8tion.jda.internal.components.AbstractComponentImpl;
import net.dv8tion.jda.internal.utils.EntityString;

public class ModalImpl
implements Modal {
    private final String id;
    private final String title;
    private final List<ModalTopLevelComponentUnion> components;

    public ModalImpl(DataObject object) {
        this.id = object.getString("custom_id");
        this.title = object.getString("title");
        this.components = object.optArray("components").map(arr -> Components.parseComponents(ModalTopLevelComponentUnion.class, arr)).orElseGet(Collections::emptyList);
    }

    public ModalImpl(String id, String title, List<ModalTopLevelComponentUnion> components) {
        this.id = id;
        this.title = title;
        this.components = Collections.unmodifiableList(components);
    }

    @Override
    @Nonnull
    public String getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Override
    @Nonnull
    public List<ModalTopLevelComponentUnion> getComponents() {
        return this.components;
    }

    @Override
    @Nonnull
    public DataObject toData() {
        DataObject object = DataObject.empty().put("custom_id", this.id).put("title", this.title);
        object.put("components", DataArray.fromCollection(this.components.stream().map(AbstractComponentImpl.class::cast).map(SerializableData::toData).collect(Collectors.toList())));
        return object;
    }

    public String toString() {
        return new EntityString(this).addMetadata("id", this.id).addMetadata("title", this.title).toString();
    }
}

