/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.components.filedisplay;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.components.Component;
import net.dv8tion.jda.api.components.MessageTopLevelComponent;
import net.dv8tion.jda.api.components.ResolvedMedia;
import net.dv8tion.jda.api.components.container.ContainerChildComponent;
import net.dv8tion.jda.api.utils.FileUpload;
import net.dv8tion.jda.internal.components.filedisplay.FileDisplayFileUpload;
import net.dv8tion.jda.internal.components.filedisplay.FileDisplayImpl;
import net.dv8tion.jda.internal.utils.Checks;

public interface FileDisplay
extends Component,
MessageTopLevelComponent,
ContainerChildComponent {
    @Nonnull
    public static FileDisplay fromFile(@Nonnull FileUpload file) {
        Checks.notNull(file, "FileUpload");
        return new FileDisplayFileUpload(file);
    }

    @Nonnull
    public static FileDisplay fromFileName(@Nonnull String fileName) {
        Checks.notNull(fileName, "File name");
        return new FileDisplayImpl("attachment://" + fileName);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public FileDisplay withUniqueId(int var1);

    @Nonnull
    @CheckReturnValue
    public FileDisplay withSpoiler(boolean var1);

    @Nonnull
    public String getUrl();

    @Nullable
    public ResolvedMedia getResolvedMedia();

    public boolean isSpoiler();
}

