/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.components.tree;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.components.MessageTopLevelComponent;
import net.dv8tion.jda.api.components.MessageTopLevelComponentUnion;
import net.dv8tion.jda.api.components.replacer.ComponentReplacer;
import net.dv8tion.jda.api.components.tree.ComponentTree;
import net.dv8tion.jda.api.components.tree.MessageComponentTree;
import net.dv8tion.jda.internal.components.tree.AbstractComponentTree;
import net.dv8tion.jda.internal.components.utils.ComponentsUtil;
import net.dv8tion.jda.internal.utils.Checks;

public class MessageComponentTreeImpl
extends AbstractComponentTree<MessageTopLevelComponentUnion>
implements MessageComponentTree {
    private MessageComponentTreeImpl(Collection<MessageTopLevelComponentUnion> components) {
        super(components);
    }

    @Nonnull
    public static MessageComponentTree of(@Nonnull Collection<? extends MessageTopLevelComponent> components) {
        Checks.noneNull(components, "Components");
        List<MessageTopLevelComponentUnion> componentUnions = ComponentsUtil.membersToUnionWithUnknownType(components, MessageTopLevelComponentUnion.class);
        return new MessageComponentTreeImpl((Collection<MessageTopLevelComponentUnion>)componentUnions);
    }

    @Override
    @Nonnull
    public ComponentTree.Type getType() {
        return ComponentTree.Type.MESSAGE;
    }

    @Override
    @Nonnull
    public MessageComponentTree replace(@Nonnull ComponentReplacer replacer) {
        Checks.notNull(replacer, "ComponentReplacer");
        return ComponentsUtil.doReplace(MessageTopLevelComponent.class, this.components, replacer, MessageComponentTreeImpl::new);
    }

    @Override
    @Nonnull
    public MessageComponentTree withDisabled(boolean disabled) {
        return (MessageComponentTree)super.withDisabled(disabled);
    }
}

