/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;

public class SerializationUtil {
    private static final String TRUNCATED_ARRAY = "[\u2026truncated array\u2026]";
    private static final String TRUNCATED_OBJECT = "{\u2026truncated object\u2026}";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static String toShallowJsonString(Object object) throws JsonProcessingException {
        JsonNode root = objectMapper.valueToTree(object);
        JsonNode shallowRoot = SerializationUtil.pruneOneLevel(root);
        return objectMapper.writer().with(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS).writeValueAsString((Object)shallowRoot);
    }

    private static JsonNode pruneOneLevel(JsonNode n) {
        if (n.isObject()) {
            ObjectNode out = objectMapper.createObjectNode();
            for (Map.Entry e : n.properties()) {
                JsonNode v2 = (JsonNode)e.getValue();
                if (v2.isValueNode()) {
                    out.set((String)e.getKey(), v2);
                    continue;
                }
                if (v2.isArray()) {
                    out.put((String)e.getKey(), TRUNCATED_ARRAY);
                    continue;
                }
                out.put((String)e.getKey(), TRUNCATED_OBJECT);
            }
            return out;
        }
        if (n.isArray()) {
            ArrayNode out = objectMapper.createArrayNode();
            n.values().forEachRemaining(v -> {
                if (v.isValueNode()) {
                    out.add(v);
                } else if (v.isArray()) {
                    out.add(TRUNCATED_ARRAY);
                } else {
                    out.add(TRUNCATED_OBJECT);
                }
            });
            return out;
        }
        return n;
    }
}

