/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.components.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.components.Component;
import net.dv8tion.jda.api.utils.FileUpload;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.api.utils.data.SerializableData;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.message.MessageUtil;

public class ComponentSerializer {
    @Nonnull
    public DataObject serialize(@Nonnull Component component) {
        Checks.notNull(component, "Component");
        Checks.check(component instanceof SerializableData, "Component is not serializable");
        return ((SerializableData)((Object)component)).toData();
    }

    @Nonnull
    public List<DataObject> serializeAll(@Nonnull Collection<? extends Component> components) {
        Checks.noneNull(components, "Components");
        return components.stream().map(SerializableData.class::cast).map(SerializableData::toData).collect(Collectors.toList());
    }

    @Nonnull
    public List<FileUpload> getFileUploads(@Nonnull Component component) {
        Checks.notNull(component, "Component");
        return MessageUtil.getIndirectFiles(Collections.singletonList(component));
    }

    @Nonnull
    public List<FileUpload> getFileUploads(@Nonnull Collection<? extends Component> components) {
        Checks.noneNull(components, "Components");
        return MessageUtil.getIndirectFiles(components);
    }
}

