/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.cdn;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.dzikoysk.cdn.Cdn;
import net.dzikoysk.cdn.CdnUtils;
import net.dzikoysk.cdn.entity.Description;
import net.dzikoysk.cdn.module.CdnModule;
import net.dzikoysk.cdn.module.Modules;
import net.dzikoysk.cdn.reflect.DefaultMemberResolver;
import net.dzikoysk.cdn.reflect.MemberResolver;
import net.dzikoysk.cdn.reflect.Visibility;
import net.dzikoysk.cdn.serdes.Composer;
import net.dzikoysk.cdn.serdes.DescriptionProvider;
import net.dzikoysk.cdn.serdes.DescriptionResolver;
import net.dzikoysk.cdn.serdes.Deserializer;
import net.dzikoysk.cdn.serdes.Serializer;
import net.dzikoysk.cdn.serdes.SimpleComposer;
import net.dzikoysk.cdn.serdes.SimpleDeserializer;
import net.dzikoysk.cdn.serdes.SimpleSerializer;
import net.dzikoysk.cdn.serdes.composers.EnumComposer;
import net.dzikoysk.cdn.serdes.composers.ListComposer;
import net.dzikoysk.cdn.serdes.composers.MapComposer;
import net.dzikoysk.cdn.serdes.composers.ReferenceComposer;
import panda.std.Result;
import panda.std.reactive.MutableReference;
import panda.std.reactive.Reference;
import panda.utilities.ClassUtils;
import panda.utilities.ObjectUtils;

public final class CdnSettings {
    private final Map<Class<?>, Composer> composers = new HashMap();
    private final Map<Predicate<Class<?>>, Composer> dynamicComposers = new HashMap();
    private final Set<DescriptionResolver<?>> descriptionResolvers = new HashSet();
    private final Map<String, String> placeholders = new HashMap<String, String>();
    private final Modules modules = new Modules();
    private MemberResolver memberResolver = new DefaultMemberResolver(Visibility.PUBLIC);

    public CdnSettings() {
        this.withComposer(Boolean.TYPE, (T value) -> Result.ok((Object)value.toString()), (String value) -> Result.attempt(Exception.class, () -> Boolean.parseBoolean(value)));
        this.withComposer(Byte.TYPE, (T value) -> Result.ok((Object)value.toString()), (String value) -> Result.attempt(Exception.class, () -> Byte.parseByte(value)));
        this.withComposer(Short.TYPE, (T value) -> Result.ok((Object)value.toString()), (String value) -> Result.attempt(Exception.class, () -> Short.parseShort(value)));
        this.withComposer(Integer.TYPE, (T value) -> Result.ok((Object)value.toString()), (String value) -> Result.attempt(Exception.class, () -> Integer.parseInt(value)));
        this.withComposer(Long.TYPE, (T value) -> Result.ok((Object)value.toString()), (String value) -> Result.attempt(Exception.class, () -> Long.parseLong(value)));
        this.withComposer(Float.TYPE, (T value) -> Result.ok((Object)value.toString()), (String value) -> Result.attempt(Exception.class, () -> Float.valueOf(Float.parseFloat(value))));
        this.withComposer(Double.TYPE, (T value) -> Result.ok((Object)value.toString()), (String value) -> Result.attempt(Exception.class, () -> Double.parseDouble(value)));
        this.withComposer(String.class, (T value) -> Result.ok((Object)CdnUtils.stringify(value)), (String value) -> Result.ok((Object)CdnUtils.destringify(value)));
        this.withComposer(Class.class, (T value) -> Result.ok((Object)value.getName()), (String value) -> Result.attempt(Exception.class, () -> Class.forName(value)));
        this.withComposer(List.class, new ListComposer());
        this.withComposer(ArrayList.class, new ListComposer());
        this.withComposer(LinkedList.class, new ListComposer());
        this.withComposer(Map.class, new MapComposer());
        this.withComposer(HashMap.class, new MapComposer());
        this.withComposer(TreeMap.class, new MapComposer());
        this.withComposer(LinkedHashMap.class, new MapComposer());
        this.withComposer(ConcurrentHashMap.class, new MapComposer());
        this.withComposer(Reference.class, new ReferenceComposer());
        this.withComposer(MutableReference.class, new ReferenceComposer());
        this.withDynamicComposer(Class::isEnum, new EnumComposer());
        this.withDescriptionResolver(Description.class, description -> Arrays.asList(description.value()));
    }

    public Cdn build() {
        if (this.modules.isEmpty()) {
            throw new IllegalStateException("CDN requires at least one registered feature. Use DefaultStandardFeature for standard CDN format");
        }
        return new Cdn(this);
    }

    public <T> CdnSettings withComposer(Class<T> type, SimpleSerializer<T> serializer, SimpleDeserializer<T> deserializer) {
        return this.withComposer(type, (Serializer<T>)serializer, (Deserializer<T>)deserializer);
    }

    public <T> CdnSettings withComposer(Class<T> type, Serializer<T> serializer, Deserializer<T> deserializer) {
        return this.withComposer(type, new SimpleComposer<T>(serializer, deserializer));
    }

    public CdnSettings withComposer(Class<?> type, Composer<?> composer) {
        this.composers.put(type, composer);
        if (type.isPrimitive()) {
            this.withComposer(ClassUtils.getNonPrimitiveClass(type), composer);
        }
        return this;
    }

    public CdnSettings withDynamicComposer(Predicate<Class<?>> filter, Composer<?> composer) {
        this.dynamicComposers.put(filter, composer);
        return this;
    }

    public CdnSettings registerPlaceholders(Map<String, String> placeholders) {
        this.placeholders.putAll(placeholders);
        return this;
    }

    public CdnSettings registerModule(CdnModule module) {
        this.modules.addModule(module);
        return this;
    }

    public CdnSettings withMemberResolver(MemberResolver resolver) {
        this.memberResolver = resolver;
        return this;
    }

    public CdnSettings withMemberResolver(Visibility visibilityToMatch) {
        this.memberResolver = new DefaultMemberResolver(visibilityToMatch);
        return this;
    }

    public <A extends Annotation> CdnSettings withDescriptionResolver(Class<A> type, DescriptionProvider<A> resolver) {
        this.descriptionResolvers.add(new DescriptionResolver<A>(type, resolver));
        return this;
    }

    public CdnModule getModule() {
        return this.modules;
    }

    public Map<? extends String, ? extends String> getPlaceholders() {
        return this.placeholders;
    }

    public Set<DescriptionResolver<?>> getDescriptionResolvers() {
        return Collections.unmodifiableSet(this.descriptionResolvers);
    }

    public Map<? extends Predicate<Class<?>>, ? extends Composer<?>> getDynamicComposers() {
        return (Map)ObjectUtils.cast(this.dynamicComposers);
    }

    public Map<? extends Class<?>, ? extends Composer<?>> getComposers() {
        return (Map)ObjectUtils.cast(this.composers);
    }

    public MemberResolver getAnnotationResolver() {
        return this.memberResolver;
    }
}

