/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.cdn;

import java.util.List;
import java.util.Map;
import net.dzikoysk.cdn.CdnException;
import net.dzikoysk.cdn.CdnSettings;
import net.dzikoysk.cdn.model.Configuration;
import net.dzikoysk.cdn.model.Element;
import net.dzikoysk.cdn.model.Entry;
import net.dzikoysk.cdn.model.Piece;
import net.dzikoysk.cdn.model.Section;
import net.dzikoysk.cdn.module.CdnModule;
import org.jetbrains.annotations.Nullable;
import panda.std.Blank;
import panda.std.Result;
import panda.utilities.StringUtils;

final class CdnWriter {
    private final CdnSettings settings;

    CdnWriter(CdnSettings settings) {
        this.settings = settings;
    }

    public Result<String, CdnException> render(Element<?> element) {
        StringBuilder content = new StringBuilder();
        return this.render(content, 0, null, element).map(success -> {
            String result = content.toString();
            for (Map.Entry<? extends String, ? extends String> entry : this.settings.getPlaceholders().entrySet()) {
                result = StringUtils.replace((String)result, (String)("${{" + entry.getKey() + "}}"), (String)entry.getValue());
            }
            return result.trim();
        }).mapErr(CdnException::new);
    }

    private Result<Blank, Exception> render(StringBuilder output, int level, @Nullable Section parent, Element<?> element) {
        String indentation = StringUtils.buildSpace((int)(level * 2));
        CdnModule module = this.settings.getModule();
        for (String description : element.getDescription()) {
            module.renderDescription(output, indentation, description);
        }
        if (element instanceof Entry) {
            return module.renderEntry(output, indentation, parent, (Entry)element);
        }
        if (element instanceof Section) {
            Section section = (Section)element;
            boolean isRoot = section instanceof Configuration;
            if (!isRoot) {
                module.renderSectionOpening(output, indentation, section);
            }
            int subLevel = isRoot ? level : level + 1;
            for (Element sectionElement : (List)section.getValue()) {
                this.render(output, subLevel, section, sectionElement);
            }
            if (!isRoot) {
                module.renderSectionEnding(output, indentation, parent, section);
            }
            return Result.ok();
        }
        if (element instanceof Piece) {
            return module.renderPiece(output, indentation, parent, (Piece)element);
        }
        return Result.error((Object)new IllegalStateException("Unknown element: " + element));
    }
}

