/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.cdn.model;

import java.util.ArrayList;
import java.util.List;
import net.dzikoysk.cdn.CdnUtils;
import net.dzikoysk.cdn.model.Element;
import net.dzikoysk.cdn.model.Piece;
import net.dzikoysk.cdn.model.Section;
import net.dzikoysk.cdn.module.standard.StandardOperators;

public class Array
extends Section {
    public Array(List<? extends String> description, String name) {
        super(description, StandardOperators.ARRAY_SEPARATOR, name);
    }

    public Array(List<? extends String> description, String name, List<? extends Element<?>> values) {
        super(description, StandardOperators.ARRAY_SEPARATOR, name, values);
    }

    public List<String> getList() {
        ArrayList<String> values = new ArrayList<String>(((List)this.getValue()).size());
        int listOperators = 0;
        for (Object element : (List)this.getValue()) {
            if (!(element instanceof Piece)) continue;
            Piece piece = (Piece)element;
            String record = piece.getValue();
            if (record.startsWith("-")) {
                ++listOperators;
            }
            if (record.endsWith(",")) {
                record = record.substring(0, record.length() - ",".length());
            }
            values.add(record);
        }
        for (int index = 0; index < values.size(); ++index) {
            Object element;
            element = (String)values.get(index);
            if (listOperators == values.size()) {
                element = ((String)element).substring(1).trim();
            }
            values.set(index, CdnUtils.destringify((String)element));
        }
        return values;
    }
}

