/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.cdn.model;

import java.util.List;
import net.dzikoysk.cdn.model.AbstractNamedElement;
import net.dzikoysk.cdn.model.Piece;

public class Entry
extends AbstractNamedElement<Piece> {
    private final String raw;

    public Entry(List<? extends String> description, String raw, String name, Piece value) {
        super(description, name, value);
        this.raw = raw;
    }

    public Entry(List<? extends String> description, String raw, String name, String value) {
        this(description, raw, name, new Piece(value));
    }

    public Entry(List<? extends String> description, String name, Piece value) {
        this(description, name + ":" + value, name, value);
    }

    public Entry(List<? extends String> description, String name, String value) {
        this(description, name + ":" + value, name, value);
    }

    public String getRecord() {
        return this.name + ": " + this.getPieceValue();
    }

    public String getRaw() {
        return this.raw;
    }

    public String getPieceValue() {
        return ((Piece)this.getValue()).getValue();
    }

    public String toString() {
        return "Entry { " + this.getRecord() + " }";
    }
}

