/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.cdn.model;

import java.util.Collections;
import java.util.List;
import net.dzikoysk.cdn.model.Element;
import net.dzikoysk.cdn.model.Entry;
import panda.utilities.StringUtils;

public final class Piece
implements Element<String> {
    private final String value;

    public Piece(String value) {
        this.value = value;
    }

    public Entry toEntry(List<? extends String> description) {
        String entryValue;
        String[] elements = StringUtils.splitFirst((String)this.value, (String)":");
        String entryKey = elements.length > 0 ? elements[0].trim() : this.value;
        String string = entryValue = elements.length == 2 ? elements[1].trim() : entryKey;
        if (entryValue.endsWith(",")) {
            entryValue = entryValue.substring(0, entryValue.length() - 1);
        }
        return new Entry(description, this.value, entryKey, entryValue);
    }

    public String toString() {
        return "Unit { " + this.value + " }";
    }

    @Override
    public List<? extends String> getDescription() {
        return Collections.emptyList();
    }

    @Override
    public String getValue() {
        return this.value;
    }
}

