/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.cdn.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collector;
import net.dzikoysk.cdn.CdnUtils;
import net.dzikoysk.cdn.model.AbstractNamedElement;
import net.dzikoysk.cdn.model.Array;
import net.dzikoysk.cdn.model.Element;
import net.dzikoysk.cdn.model.Entry;
import net.dzikoysk.cdn.model.NamedElement;
import net.dzikoysk.cdn.model.Piece;
import net.dzikoysk.cdn.module.standard.StandardOperators;
import org.jetbrains.annotations.Contract;
import panda.std.Option;
import panda.utilities.ObjectUtils;
import panda.utilities.StringUtils;

public class Section
extends AbstractNamedElement<List<? extends Element<?>>> {
    private final String[] operators;

    public Section(List<? extends String> description, String name) {
        this(description, StandardOperators.OBJECT_SEPARATOR, name);
    }

    public Section(List<? extends String> description, String[] operators, String name) {
        this(description, operators, name, new ArrayList());
    }

    public Section(List<? extends String> description, String name, List<? extends Element<?>> value) {
        this(description, StandardOperators.OBJECT_SEPARATOR, name, value);
    }

    public Section(List<? extends String> description, String[] operators, String name, List<? extends Element<?>> value) {
        super(description, name, value);
        this.operators = operators;
    }

    public <E extends Element<?>> E append(E element) {
        ((List)this.value).add((Element)ObjectUtils.cast(element));
        return element;
    }

    public void setString(String key, String value) {
        this.getEntry(key).peek(entry -> entry.setValue(new Piece(value))).orElseGet(() -> this.append(new Entry(Collections.emptyList(), key, value)));
    }

    @Contract(value="null -> false")
    public boolean has(String key) {
        return this.get(key).isDefined();
    }

    public int size() {
        return ((List)this.getValue()).size();
    }

    private <T> Option<T> get(int index, Class<T> type) {
        return this.get(index).map(element -> ObjectUtils.cast((Class)type, (Object)element));
    }

    public Option<Element<?>> get(int index) {
        return Option.when((index > -1 && index < this.size() ? 1 : 0) != 0, () -> (Element)((List)this.getValue()).get(index));
    }

    private <T> Option<T> get(String key, Class<T> type) {
        return this.get(key).map(element -> {
            Object value = ObjectUtils.cast((Class)type, (Object)element);
            if (value == null) {
                throw new IllegalStateException("Property '" + key + "' of type " + element.getClass() + " cannot be queried as " + type);
            }
            return value;
        });
    }

    @Contract(value="null -> null")
    public Option<Element<?>> get(String key) {
        if (key == null) {
            return Option.none();
        }
        for (Element element : (List)this.getValue()) {
            NamedElement namedElement;
            if (!(element instanceof NamedElement) || !key.equals((namedElement = (NamedElement)element).getName())) continue;
            return Option.of((Object)element);
        }
        return Option.when((boolean)key.contains("."), (Object)StringUtils.split((String)key, (String)".")).flatMap(qualifier -> {
            Option section = Option.of((Object)this);
            int index = 0;
            while (index < ((String[])qualifier).length - 1 && section.isDefined()) {
                int currentIndex = index++;
                section = section.flatMap(value -> value.getSection(qualifier[currentIndex]));
            }
            return section.flatMap(value -> value.get(qualifier[((String[])qualifier).length - 1]));
        });
    }

    @Contract(value="_, null -> null")
    public List<String> getList(String key, List<String> defaultValue) {
        return (List)this.getList(key).orElseGet(() -> defaultValue);
    }

    public Option<List<String>> getList(String key) {
        return this.getArray(key).map(Array::getList);
    }

    public Option<Boolean> getBoolean(String key) {
        return this.getString(key).map(Boolean::parseBoolean);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return (Boolean)this.getBoolean(key).orElseGet((Object)defaultValue);
    }

    public Option<Integer> getInt(String key) {
        return this.getString(key).map(Integer::parseInt);
    }

    public int getInt(String key, int defaultValue) {
        return (Integer)this.getInt(key).orElseGet((Object)defaultValue);
    }

    public Option<String> getString(String key) {
        return this.getEntry(key).map(Entry::getPieceValue).map(CdnUtils::destringify);
    }

    @Contract(value="_, null -> null")
    public String getString(String key, String defaultValue) {
        return (String)this.getString(key).orElseGet((Object)defaultValue);
    }

    public Option<Entry> getEntry(int index) {
        return this.get(index, Entry.class);
    }

    public Option<Entry> getEntry(String key) {
        return this.get(key, Entry.class);
    }

    public Option<Array> getArray(int index) {
        return this.getSection(index).map(Section::toArray);
    }

    public Option<Array> getArray(String key) {
        return this.getSection(key).map(Section::toArray);
    }

    private Array toArray() {
        return new Array((List<? extends String>)this.description, this.name, (List)this.value);
    }

    public Option<Section> getSection(int index) {
        return this.get(index, Section.class);
    }

    public Option<Section> getSection(String key) {
        return this.get(key, Section.class);
    }

    public String[] getOperators() {
        return this.operators;
    }

    public static Collector<Element<?>, Section, Section> collector(Supplier<Section> sectionSupplier) {
        return Collector.of(sectionSupplier, Section::append, (left, right) -> {
            ((List)right.getValue()).forEach(left::append);
            return left;
        }, new Collector.Characteristics[0]);
    }
}

