/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.cdn.module;

import java.util.List;
import java.util.Stack;
import net.dzikoysk.cdn.model.Element;
import net.dzikoysk.cdn.model.Entry;
import net.dzikoysk.cdn.model.Piece;
import net.dzikoysk.cdn.model.Section;
import org.jetbrains.annotations.Nullable;
import panda.std.Blank;
import panda.std.Result;

public interface CdnModule {
    default public String convertToCdn(String source) {
        return source;
    }

    default public Element<?> visitArrayValue(Element<?> element) {
        return element;
    }

    default public Element<?> resolveArrayValue(Element<?> element) {
        return element;
    }

    default public boolean resolveArray(Stack<Section> sections, Piece value) {
        return false;
    }

    default public void renderDescription(StringBuilder output, String indentation, String description) {
    }

    default public void renderSectionOpening(StringBuilder output, String indentation, Section section) {
    }

    default public void renderSectionEnding(StringBuilder output, String indentation, @Nullable Section parent, Section section) {
    }

    default public Result<Blank, Exception> renderEntry(StringBuilder output, String indentation, @Nullable Section parent, Entry element) {
        return Result.ok();
    }

    default public Result<Blank, Exception> renderPiece(StringBuilder output, String indentation, @Nullable Section parent, Piece element) {
        return Result.ok();
    }

    public static boolean isLastElementInSection(@Nullable Section parent, Element<?> element) {
        return parent == null || ((List)parent.getValue()).indexOf(element) == ((List)parent.getValue()).size() - 1;
    }
}

