/*
 * Decompiled with CFR 0.152.
 */
package net.dzikoysk.cdn.module.json;

import net.dzikoysk.cdn.CdnUtils;
import net.dzikoysk.cdn.model.Element;
import net.dzikoysk.cdn.model.Entry;
import net.dzikoysk.cdn.model.Piece;
import net.dzikoysk.cdn.model.Section;
import net.dzikoysk.cdn.module.CdnModule;
import net.dzikoysk.cdn.module.json.JsonToCdnConverter;
import net.dzikoysk.cdn.module.shared.ArrayValueVisitor;
import net.dzikoysk.cdn.module.standard.StandardModule;
import org.jetbrains.annotations.Nullable;
import panda.std.Blank;
import panda.std.Result;

public final class JsonLikeModule
extends StandardModule {
    private static final ArrayValueVisitor ARRAY_VALUE_VISITOR = new ArrayValueVisitor("", "", true);

    @Override
    public String convertToCdn(String source) {
        String standardized = source.replace("\r\n", "\n");
        return new JsonToCdnConverter().enforceNewlines(standardized);
    }

    @Override
    public Element<?> visitArrayValue(Element<?> element) {
        return ARRAY_VALUE_VISITOR.visit(element);
    }

    @Override
    public void renderDescription(StringBuilder output, String indentation, String description) {
    }

    @Override
    public void renderSectionOpening(StringBuilder output, String indentation, Section section) {
        output.append(indentation).append(CdnUtils.forceStringify(section.getName())).append(": ").append(section.getOperators()[0]).append("\n");
    }

    @Override
    public void renderSectionEnding(StringBuilder output, String indentation, @Nullable Section parent, Section section) {
        output.append(indentation).append(section.getOperators()[1]);
        if (!CdnModule.isLastElementInSection(parent, section)) {
            output.append(",");
        }
        output.append("\n");
    }

    @Override
    public Result<Blank, Exception> renderEntry(StringBuilder output, String indentation, @Nullable Section parent, Entry element) {
        output.append(indentation).append(CdnUtils.forceStringify(element.getName())).append(":").append(" ").append(CdnUtils.forceStringify(element.getPieceValue()));
        if (!CdnModule.isLastElementInSection(parent, element)) {
            output.append(",");
        }
        output.append("\n");
        return Result.ok();
    }

    @Override
    public Result<Blank, Exception> renderPiece(StringBuilder output, String indentation, @Nullable Section parent, Piece element) {
        output.append(indentation).append(CdnUtils.forceStringify(element.getValue()));
        if (!CdnModule.isLastElementInSection(parent, element)) {
            output.append(",");
        }
        output.append("\n");
        return Result.ok();
    }
}

